/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.packets.unsuback;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.unsuback.ModifiableUnsubackPacket;
import com.hivemq.extension.sdk.api.packets.unsuback.UnsubackReasonCode;
import com.hivemq.extensions.packets.general.ModifiableUserPropertiesImpl;
import com.hivemq.extensions.packets.unsuback.UnsubackPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.mqtt.message.reason.Mqtt5UnsubAckReasonCode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ModifiableUnsubackPacketImpl
implements ModifiableUnsubackPacket {
    @NotNull
    private ImmutableList<UnsubackReasonCode> reasonCodes;
    @Nullable
    private String reasonString;
    private final int packetIdentifier;
    @NotNull
    private final ModifiableUserPropertiesImpl userProperties;
    @NotNull
    private final FullConfigurationService configurationService;
    private boolean modified = false;

    public ModifiableUnsubackPacketImpl(@NotNull UnsubackPacketImpl packet, @NotNull FullConfigurationService configurationService) {
        this.reasonCodes = packet.reasonCodes;
        this.reasonString = packet.reasonString;
        this.packetIdentifier = packet.packetIdentifier;
        this.userProperties = new ModifiableUserPropertiesImpl(packet.userProperties.asInternalList(), configurationService.securityConfiguration().validateUTF8());
        this.configurationService = configurationService;
    }

    @NotNull
    public ImmutableList<UnsubackReasonCode> getReasonCodes() {
        return this.reasonCodes;
    }

    public void setReasonCodes(@NotNull @NotNull List<@NotNull UnsubackReasonCode> reasonCodes) {
        Preconditions.checkNotNull(reasonCodes, (Object)"Reason codes must never be null.");
        if (reasonCodes.size() != this.reasonCodes.size()) {
            throw new IllegalArgumentException("The amount of reason codes must not be changed.");
        }
        for (int i = 0; i < reasonCodes.size(); ++i) {
            Preconditions.checkNotNull((Object)reasonCodes.get(i), (String)"Reason code (at index %s) must never be null.", (int)i);
            Mqtt5UnsubAckReasonCode oldReasonCode = Mqtt5UnsubAckReasonCode.from((UnsubackReasonCode)this.reasonCodes.get(i));
            Mqtt5UnsubAckReasonCode newReasonCode = Mqtt5UnsubAckReasonCode.from(reasonCodes.get(i));
            Preconditions.checkState((newReasonCode.isError() == oldReasonCode.isError() ? 1 : 0) != 0, (String)"Reason code (at index %s) must not switch from successful to unsuccessful or vice versa.", (int)i);
        }
        if (Objects.equals(this.reasonCodes, reasonCodes)) {
            return;
        }
        this.reasonCodes = ImmutableList.copyOf(reasonCodes);
        this.modified = true;
    }

    @NotNull
    public Optional<String> getReasonString() {
        return Optional.ofNullable(this.reasonString);
    }

    public void setReasonString(@Nullable String reasonString) {
        PluginBuilderUtil.checkReasonString(reasonString, this.configurationService.securityConfiguration().validateUTF8());
        if (Objects.equals(this.reasonString, reasonString)) {
            return;
        }
        this.reasonString = reasonString;
        this.modified = true;
    }

    public int getPacketIdentifier() {
        return this.packetIdentifier;
    }

    @NotNull
    public ModifiableUserPropertiesImpl getUserProperties() {
        return this.userProperties;
    }

    public boolean isModified() {
        return this.modified || this.userProperties.isModified();
    }

    @NotNull
    public UnsubackPacketImpl copy() {
        return new UnsubackPacketImpl(this.reasonCodes, this.reasonString, this.packetIdentifier, this.userProperties.copy());
    }

    @NotNull
    public ModifiableUnsubackPacketImpl update(@NotNull UnsubackPacketImpl packet) {
        return new ModifiableUnsubackPacketImpl(packet, this.configurationService);
    }
}

