/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.connect.WillPublishPacket;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.packets.general.UserProperties;
import com.hivemq.extension.sdk.api.packets.general.UserProperty;
import com.hivemq.extension.sdk.api.packets.publish.PayloadFormatIndicator;
import com.hivemq.extension.sdk.api.packets.publish.PublishPacket;
import com.hivemq.extension.sdk.api.services.builder.WillPublishBuilder;
import com.hivemq.extension.sdk.api.services.exception.DoNotImplementException;
import com.hivemq.extension.sdk.api.services.publish.Publish;
import com.hivemq.extensions.packets.general.UserPropertiesImpl;
import com.hivemq.extensions.packets.publish.PublishPacketImpl;
import com.hivemq.extensions.packets.publish.WillPublishPacketImpl;
import com.hivemq.extensions.services.builder.PluginBuilderUtil;
import com.hivemq.extensions.services.publish.PublishImpl;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.util.Topics;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.inject.Inject;

public class WillPublishBuilderImpl
implements WillPublishBuilder {
    @NotNull
    private Qos qos = Qos.AT_MOST_ONCE;
    private boolean retain = false;
    private long willDelay = 0L;
    @Nullable
    private String topic;
    @Nullable
    private PayloadFormatIndicator payloadFormatIndicator;
    private long messageExpiryInterval = Long.MAX_VALUE;
    @Nullable
    private String responseTopic;
    @Nullable
    private ByteBuffer correlationData;
    @Nullable
    private String contentType;
    @Nullable
    private ByteBuffer payload;
    @NotNull
    private final ImmutableList.Builder<MqttUserProperty> userPropertyBuilder = ImmutableList.builder();
    @NotNull
    private final MqttConfigurationService mqttConfigurationService;
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfig;
    @NotNull
    private final SecurityConfigurationService securityConfigurationService;

    @Inject
    public WillPublishBuilderImpl(@NotNull FullConfigurationService fullConfigurationService) {
        this.mqttConfigurationService = fullConfigurationService.mqttConfiguration();
        this.restrictionsConfig = fullConfigurationService.restrictionsConfiguration();
        this.securityConfigurationService = fullConfigurationService.securityConfiguration();
    }

    @NotNull
    public WillPublishBuilder fromPublish(@NotNull PublishPacket publishPacket) {
        Preconditions.checkNotNull((Object)publishPacket, (Object)"publish must not be null");
        if (!(publishPacket instanceof PublishPacketImpl)) {
            throw new DoNotImplementException(PublishPacket.class.getSimpleName());
        }
        return this.fromComplete(publishPacket.getQos(), publishPacket.getRetain(), publishPacket.getTopic(), publishPacket.getPayloadFormatIndicator(), publishPacket.getMessageExpiryInterval(), publishPacket.getResponseTopic(), publishPacket.getCorrelationData(), publishPacket.getContentType(), publishPacket.getPayload(), publishPacket.getUserProperties(), 0L);
    }

    @NotNull
    public WillPublishBuilder fromPublish(@NotNull Publish publish) {
        Preconditions.checkNotNull((Object)publish, (Object)"publish must not be null");
        if (!(publish instanceof PublishImpl)) {
            throw new DoNotImplementException(Publish.class.getSimpleName());
        }
        return this.fromComplete(publish.getQos(), publish.getRetain(), publish.getTopic(), publish.getPayloadFormatIndicator(), publish.getMessageExpiryInterval(), publish.getResponseTopic(), publish.getCorrelationData(), publish.getContentType(), publish.getPayload(), publish.getUserProperties(), 0L);
    }

    @NotNull
    public WillPublishBuilder fromWillPublish(@NotNull WillPublishPacket willPublish) {
        Preconditions.checkNotNull((Object)willPublish, (Object)"publish must not be null");
        if (!(willPublish instanceof WillPublishPacketImpl)) {
            throw new DoNotImplementException(WillPublishPacket.class.getSimpleName());
        }
        return this.fromComplete(willPublish.getQos(), willPublish.getRetain(), willPublish.getTopic(), willPublish.getPayloadFormatIndicator(), willPublish.getMessageExpiryInterval(), willPublish.getResponseTopic(), willPublish.getCorrelationData(), willPublish.getContentType(), willPublish.getPayload(), willPublish.getUserProperties(), willPublish.getWillDelay());
    }

    @NotNull
    private WillPublishBuilder fromComplete(@NotNull Qos qos, boolean retain, @NotNull String topic, @NotNull Optional<PayloadFormatIndicator> payloadFormatIndicator, @NotNull Optional<Long> messageExpiryInterval, @NotNull Optional<String> responseTopic, @NotNull Optional<ByteBuffer> correlationData, @NotNull Optional<String> contentType, @NotNull Optional<ByteBuffer> payload, @NotNull UserProperties userProperties, long willDelay) {
        this.qos = qos;
        this.retain = retain;
        this.topic = topic;
        this.payloadFormatIndicator = payloadFormatIndicator.orElse(null);
        this.messageExpiryInterval = messageExpiryInterval.orElse(Long.MAX_VALUE);
        this.responseTopic = responseTopic.orElse(null);
        this.correlationData = correlationData.orElse(null);
        this.contentType = contentType.orElse(null);
        this.payload = payload.orElse(null);
        for (UserProperty userProperty : userProperties.asList()) {
            this.userProperty(userProperty.getName(), userProperty.getValue());
        }
        this.willDelay = willDelay;
        return this;
    }

    @NotNull
    public WillPublishBuilder qos(@NotNull Qos qos) {
        PluginBuilderUtil.checkQos(qos, this.mqttConfigurationService.maximumQos().getQosNumber());
        this.qos = qos;
        return this;
    }

    @NotNull
    public WillPublishBuilder retain(boolean retain) {
        if (!this.mqttConfigurationService.retainedMessagesEnabled() && retain) {
            throw new IllegalArgumentException("Retained messages are disabled");
        }
        this.retain = retain;
        return this;
    }

    @NotNull
    public WillPublishBuilder topic(@NotNull String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must not be null");
        Preconditions.checkArgument((topic.length() <= this.restrictionsConfig.maxTopicLength() ? 1 : 0) != 0, (Object)("Topic filter length must not exceed '" + this.restrictionsConfig.maxTopicLength() + "' characters, but has '" + topic.length() + "' characters"));
        if (!Topics.isValidTopicToPublish(topic)) {
            throw new IllegalArgumentException("The topic (" + topic + ") is invalid for PUBLISH messages");
        }
        if (!PluginBuilderUtil.isValidUtf8String(topic, this.securityConfigurationService.validateUTF8())) {
            throw new IllegalArgumentException("The topic (" + topic + ") is UTF-8 malformed");
        }
        this.topic = topic;
        return this;
    }

    @NotNull
    public WillPublishBuilder payloadFormatIndicator(@Nullable PayloadFormatIndicator payloadFormatIndicator) {
        this.payloadFormatIndicator = payloadFormatIndicator;
        return this;
    }

    @NotNull
    public WillPublishBuilder messageExpiryInterval(long messageExpiryInterval) {
        PluginBuilderUtil.checkMessageExpiryInterval(messageExpiryInterval, this.mqttConfigurationService.maxMessageExpiryInterval());
        this.messageExpiryInterval = messageExpiryInterval;
        return this;
    }

    @NotNull
    public WillPublishBuilder responseTopic(@Nullable String responseTopic) {
        PluginBuilderUtil.checkResponseTopic(responseTopic, this.securityConfigurationService.validateUTF8());
        this.responseTopic = responseTopic;
        return this;
    }

    @NotNull
    public WillPublishBuilder correlationData(@Nullable ByteBuffer correlationData) {
        this.correlationData = correlationData;
        return this;
    }

    @NotNull
    public WillPublishBuilder contentType(@Nullable String contentType) {
        PluginBuilderUtil.checkContentType(contentType, this.securityConfigurationService.validateUTF8());
        this.contentType = contentType;
        return this;
    }

    @NotNull
    public WillPublishBuilder payload(@NotNull ByteBuffer payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must not be null");
        this.payload = payload;
        return this;
    }

    @NotNull
    public WillPublishBuilder userProperty(@NotNull String name, @NotNull String value) {
        PluginBuilderUtil.checkUserProperty(name, value, this.securityConfigurationService.validateUTF8());
        this.userPropertyBuilder.add((Object)new MqttUserProperty(name, value));
        return this;
    }

    @NotNull
    public WillPublishBuilder willDelay(long willDelay) {
        Preconditions.checkArgument((willDelay > -1L ? 1 : 0) != 0, (Object)"Will delay must never be less than zero.");
        this.willDelay = willDelay;
        return this;
    }

    @NotNull
    public WillPublishPacket build() {
        Preconditions.checkNotNull((Object)this.topic, (Object)"Topic must never be null");
        Preconditions.checkNotNull((Object)this.payload, (Object)"Payload must never be null");
        if (this.messageExpiryInterval == Long.MAX_VALUE) {
            this.messageExpiryInterval = this.mqttConfigurationService.maxMessageExpiryInterval();
        }
        return new WillPublishPacketImpl(this.topic, this.qos, this.payload, this.retain, this.messageExpiryInterval, this.payloadFormatIndicator, this.contentType, this.responseTopic, this.correlationData, UserPropertiesImpl.of((ImmutableList<MqttUserProperty>)this.userPropertyBuilder.build()), this.willDelay, System.currentTimeMillis());
    }
}

