/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.services.subscription;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.general.Qos;
import com.hivemq.extension.sdk.api.services.subscription.TopicSubscription;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.mqtt5.Mqtt5RetainHandling;
import com.hivemq.mqtt.message.subscribe.Topic;
import java.util.Objects;
import java.util.Optional;

public class TopicSubscriptionImpl
implements TopicSubscription {
    @NotNull
    private final String topicFilter;
    @NotNull
    private final Qos qos;
    private final boolean retainAsPublished;
    private final boolean noLocal;
    @Nullable
    private final Integer subscriptionIdentifier;

    public TopicSubscriptionImpl(@NotNull String topicFilter, @NotNull Qos qos, boolean retainAsPublished, boolean noLocal, @Nullable Integer subscriptionIdentifier) {
        Preconditions.checkNotNull((Object)topicFilter, (Object)"Topic filter must never be null");
        Preconditions.checkNotNull((Object)qos, (Object)"QoS must never be null");
        this.topicFilter = topicFilter;
        this.qos = qos;
        this.retainAsPublished = retainAsPublished;
        this.noLocal = noLocal;
        this.subscriptionIdentifier = subscriptionIdentifier;
    }

    public TopicSubscriptionImpl(@NotNull Topic topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"Topic must never be null");
        this.topicFilter = topic.getTopic();
        this.qos = topic.getQoS().toQos();
        this.retainAsPublished = topic.isRetainAsPublished();
        this.noLocal = topic.isNoLocal();
        this.subscriptionIdentifier = topic.getSubscriptionIdentifier();
    }

    @NotNull
    public String getTopicFilter() {
        return this.topicFilter;
    }

    @NotNull
    public Qos getQos() {
        return this.qos;
    }

    public boolean getRetainAsPublished() {
        return this.retainAsPublished;
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    @NotNull
    public Optional<Integer> getSubscriptionIdentifier() {
        return Optional.ofNullable(this.subscriptionIdentifier);
    }

    @NotNull
    public static Topic convertToTopic(@NotNull TopicSubscription topicSubscription) {
        Preconditions.checkNotNull((Object)topicSubscription, (Object)"TopicSubscription must never be null");
        return new Topic(topicSubscription.getTopicFilter(), Objects.requireNonNull(QoS.valueOf(topicSubscription.getQos().getQosNumber())), topicSubscription.getNoLocal(), topicSubscription.getRetainAsPublished(), Objects.requireNonNull(Mqtt5RetainHandling.DO_NOT_SEND), topicSubscription.getSubscriptionIdentifier().orElse(null));
    }

    public String toString() {
        return "TopicSubscription{topicFilter='" + this.topicFilter + "', qos=" + this.qos + ", retainAsPublished=" + this.retainAsPublished + ", noLocal=" + this.noLocal + ", subscriptionIdentifier=" + this.subscriptionIdentifier + "}";
    }
}

