/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.logging.modifier;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.spi.FilterReply;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.logging.modifier.LogLevelModifier;
import org.slf4j.Marker;

public class NettyLogLevelModifier
implements LogLevelModifier {
    @Override
    @NotNull
    public FilterReply decide(@Nullable Marker marker, @NotNull Logger logger, @NotNull Level level, @NotNull String format, @Nullable @Nullable Object @Nullable [] params, @Nullable Throwable t) {
        if (level == Level.DEBUG) {
            if (logger.getName().startsWith("io.netty")) {
                if (logger.getName().startsWith("io.netty.handler.traffic.")) {
                    return FilterReply.DENY;
                }
                if (logger.getName().startsWith("io.netty.util.internal.NativeLibraryLoader")) {
                    if (t instanceof UnsatisfiedLinkError) {
                        return FilterReply.DENY;
                    }
                    if (params == null) {
                        logger.trace(marker, format, params);
                        return FilterReply.DENY;
                    }
                    for (Object param : params) {
                        if (!(param instanceof UnsatisfiedLinkError)) continue;
                        return FilterReply.DENY;
                    }
                    logger.trace(marker, format, params);
                    return FilterReply.DENY;
                }
                NettyLogLevelModifier.traceAndSortOutUnsupportedOperationException(marker, logger, format, params, t);
                return FilterReply.DENY;
            }
        } else if (level == Level.TRACE && logger.getName().startsWith("io.netty.channel.nio.NioEventLoop")) {
            if (t instanceof UnsupportedOperationException) {
                return FilterReply.DENY;
            }
            if (params != null) {
                for (Object param : params) {
                    if (!(param instanceof UnsupportedOperationException)) continue;
                    return FilterReply.DENY;
                }
            }
        }
        return FilterReply.NEUTRAL;
    }

    private static void traceAndSortOutUnsupportedOperationException(@Nullable Marker marker, @NotNull Logger logger, @NotNull String format, @Nullable @Nullable Object @Nullable [] params, @Nullable Throwable t) {
        if (t instanceof UnsupportedOperationException) {
            return;
        }
        if (params != null) {
            for (Object param : params) {
                if (!(param instanceof UnsupportedOperationException)) continue;
                return;
            }
        }
        logger.trace(marker, format, params);
    }
}

