/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.migration.logging;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.Formatter;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class PayloadExceptionLogging {
    private static final Logger migrationLog = LoggerFactory.getLogger((String)"migrations");
    private static final int LOGGING_INTERVAL = 10000;
    private static final String bigLine = "================================================================================";
    private static final String smallLine = "--------------------------------------------------------------------------------";
    private int counter = 0;
    @NotNull
    private final Map<Long, MissingMessageInformation> payloadIdMissingMessagesMap = new TreeMap<Long, MissingMessageInformation>();

    @VisibleForTesting
    public PayloadExceptionLogging() {
    }

    public synchronized void addLogging(long payloadId, @Nullable Boolean retained, @Nullable String retainedTopic) {
        MissingMessageInformation information = this.payloadIdMissingMessagesMap.containsKey(payloadId) ? this.payloadIdMissingMessagesMap.get(payloadId) : new MissingMessageInformation(payloadId);
        if (retained != null && retainedTopic != null) {
            information.setRetained(retained);
            information.setTopic(retainedTopic);
        }
        this.payloadIdMissingMessagesMap.put(payloadId, information);
        ++this.counter;
        if (this.counter > 10000) {
            this.logAndClear();
        }
    }

    public synchronized void logAndClear() {
        if (this.payloadIdMissingMessagesMap.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        formatter.format("%n%1$31s%n%n", "MISSING PAYLOADS");
        formatter.format("%1$19s | %2$8s | %3$47s %n", "payloadId", "retained", "topic");
        formatter.format("%1$s%n", bigLine);
        for (Map.Entry<Long, MissingMessageInformation> entry : this.payloadIdMissingMessagesMap.entrySet()) {
            MissingMessageInformation missingMessage = entry.getValue();
            formatter.format("%1$19d | %2$8b | %3$47s %n", missingMessage.getPayloadId(), missingMessage.isRetained(), missingMessage.getTopic());
            formatter.format("%n%1$s%n", smallLine);
        }
        formatter.flush();
        migrationLog.warn(stringBuilder.toString());
        this.payloadIdMissingMessagesMap.clear();
    }

    @NotNull
    @VisibleForTesting
    Map<Long, MissingMessageInformation> getMap() {
        return this.payloadIdMissingMessagesMap;
    }

    static class MissingMessageInformation {
        private final long payloadId;
        private boolean retained;
        @Nullable
        private String topic;

        private MissingMessageInformation(long payloadId) {
            this.payloadId = payloadId;
        }

        public long getPayloadId() {
            return this.payloadId;
        }

        public boolean isRetained() {
            return this.retained;
        }

        public void setRetained(boolean retained) {
            this.retained = retained;
        }

        @Nullable
        public String getTopic() {
            return this.topic;
        }

        public void setTopic(@NotNull String topic) {
            this.topic = topic;
        }
    }
}

