/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extensions.handler.ConnackOutboundInterceptorHandler;
import com.hivemq.extensions.handler.ConnectInboundInterceptorHandler;
import com.hivemq.extensions.handler.DisconnectInterceptorHandler;
import com.hivemq.extensions.handler.PingInterceptorHandler;
import com.hivemq.extensions.handler.PubackInterceptorHandler;
import com.hivemq.extensions.handler.PubcompInterceptorHandler;
import com.hivemq.extensions.handler.PublishOutboundInterceptorHandler;
import com.hivemq.extensions.handler.PubrecInterceptorHandler;
import com.hivemq.extensions.handler.PubrelInterceptorHandler;
import com.hivemq.extensions.handler.SubackOutboundInterceptorHandler;
import com.hivemq.extensions.handler.UnsubackOutboundInterceptorHandler;
import com.hivemq.extensions.handler.UnsubscribeInboundInterceptorHandler;
import com.hivemq.mqtt.message.PINGREQ;
import com.hivemq.mqtt.message.PINGRESP;
import com.hivemq.mqtt.message.connack.CONNACK;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.puback.PUBACK;
import com.hivemq.mqtt.message.pubcomp.PUBCOMP;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.pubrec.PUBREC;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.mqtt.message.suback.SUBACK;
import com.hivemq.mqtt.message.unsuback.UNSUBACK;
import com.hivemq.mqtt.message.unsubscribe.UNSUBSCRIBE;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ChannelHandler.Sharable
public class InterceptorHandler
extends ChannelDuplexHandler {
    @NotNull
    private final ConnectInboundInterceptorHandler connectInboundInterceptorHandler;
    @NotNull
    private final ConnackOutboundInterceptorHandler connackOutboundInterceptorHandler;
    @NotNull
    private final PublishOutboundInterceptorHandler publishOutboundInterceptorHandler;
    @NotNull
    private final PubackInterceptorHandler pubackInterceptorHandler;
    @NotNull
    private final PubrecInterceptorHandler pubrecInterceptorHandler;
    @NotNull
    private final PubrelInterceptorHandler pubrelInterceptorHandler;
    @NotNull
    private final PubcompInterceptorHandler pubcompInterceptorHandler;
    @NotNull
    private final SubackOutboundInterceptorHandler subackOutboundInterceptorHandler;
    @NotNull
    private final UnsubscribeInboundInterceptorHandler unsubscribeInboundInterceptorHandler;
    @NotNull
    private final UnsubackOutboundInterceptorHandler unsubackOutboundInterceptorHandler;
    @NotNull
    private final PingInterceptorHandler pingInterceptorHandler;
    @NotNull
    private final DisconnectInterceptorHandler disconnectInterceptorHandler;

    @Inject
    public InterceptorHandler(@NotNull ConnectInboundInterceptorHandler connectInboundInterceptorHandler, @NotNull ConnackOutboundInterceptorHandler connackOutboundInterceptorHandler, @NotNull PublishOutboundInterceptorHandler publishOutboundInterceptorHandler, @NotNull PubackInterceptorHandler pubackInterceptorHandler, @NotNull PubrecInterceptorHandler pubrecInterceptorHandler, @NotNull PubrelInterceptorHandler pubrelInterceptorHandler, @NotNull PubcompInterceptorHandler pubcompInterceptorHandler, @NotNull SubackOutboundInterceptorHandler subackOutboundInterceptorHandler, @NotNull UnsubscribeInboundInterceptorHandler unsubscribeInboundInterceptorHandler, @NotNull UnsubackOutboundInterceptorHandler unsubackOutboundInterceptorHandler, @NotNull PingInterceptorHandler pingInterceptorHandler, @NotNull DisconnectInterceptorHandler disconnectInterceptorHandler) {
        this.connectInboundInterceptorHandler = connectInboundInterceptorHandler;
        this.connackOutboundInterceptorHandler = connackOutboundInterceptorHandler;
        this.publishOutboundInterceptorHandler = publishOutboundInterceptorHandler;
        this.pubackInterceptorHandler = pubackInterceptorHandler;
        this.pubrecInterceptorHandler = pubrecInterceptorHandler;
        this.pubrelInterceptorHandler = pubrelInterceptorHandler;
        this.pubcompInterceptorHandler = pubcompInterceptorHandler;
        this.subackOutboundInterceptorHandler = subackOutboundInterceptorHandler;
        this.unsubscribeInboundInterceptorHandler = unsubscribeInboundInterceptorHandler;
        this.unsubackOutboundInterceptorHandler = unsubackOutboundInterceptorHandler;
        this.pingInterceptorHandler = pingInterceptorHandler;
        this.disconnectInterceptorHandler = disconnectInterceptorHandler;
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
        if (msg instanceof PUBLISH) {
            ctx.fireChannelRead(msg);
        } else if (msg instanceof PUBACK) {
            this.pubackInterceptorHandler.handleInboundPuback(ctx, (PUBACK)msg);
        } else if (msg instanceof PUBREC) {
            this.pubrecInterceptorHandler.handleInboundPubrec(ctx, (PUBREC)msg);
        } else if (msg instanceof PUBREL) {
            this.pubrelInterceptorHandler.handleInboundPubrel(ctx, (PUBREL)msg);
        } else if (msg instanceof PUBCOMP) {
            this.pubcompInterceptorHandler.handleInboundPubcomp(ctx, (PUBCOMP)msg);
        } else if (msg instanceof PINGREQ) {
            this.pingInterceptorHandler.handleInboundPingReq(ctx, (PINGREQ)msg);
        } else if (msg instanceof UNSUBSCRIBE) {
            this.unsubscribeInboundInterceptorHandler.handleInboundUnsubscribe(ctx, (UNSUBSCRIBE)msg);
        } else if (msg instanceof DISCONNECT) {
            this.disconnectInterceptorHandler.handleInboundDisconnect(ctx, (DISCONNECT)msg);
        } else if (msg instanceof CONNECT) {
            this.connectInboundInterceptorHandler.handleInboundConnect(ctx, (CONNECT)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void write(@NotNull ChannelHandlerContext ctx, @NotNull Object msg, @NotNull ChannelPromise promise) {
        if (msg instanceof PUBLISH) {
            this.publishOutboundInterceptorHandler.handleOutboundPublish(ctx, (PUBLISH)msg, promise);
        } else if (msg instanceof PUBACK) {
            this.pubackInterceptorHandler.handleOutboundPuback(ctx, (PUBACK)msg, promise);
        } else if (msg instanceof PUBREC) {
            this.pubrecInterceptorHandler.handleOutboundPubrec(ctx, (PUBREC)msg, promise);
        } else if (msg instanceof PUBREL) {
            this.pubrelInterceptorHandler.handleOutboundPubrel(ctx, (PUBREL)msg, promise);
        } else if (msg instanceof PUBCOMP) {
            this.pubcompInterceptorHandler.handleOutboundPubcomp(ctx, (PUBCOMP)msg, promise);
        } else if (msg instanceof PINGRESP) {
            this.pingInterceptorHandler.handleOutboundPingResp(ctx, (PINGRESP)msg, promise);
        } else if (msg instanceof SUBACK) {
            this.subackOutboundInterceptorHandler.handleOutboundSuback(ctx, (SUBACK)msg, promise);
        } else if (msg instanceof UNSUBACK) {
            this.unsubackOutboundInterceptorHandler.handleOutboundUnsuback(ctx, (UNSUBACK)msg, promise);
        } else if (msg instanceof CONNACK) {
            this.connackOutboundInterceptorHandler.handleOutboundConnack(ctx, (CONNACK)msg, promise);
        } else if (msg instanceof DISCONNECT) {
            this.disconnectInterceptorHandler.handleOutboundDisconnect(ctx, (DISCONNECT)msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }
}

