/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.connect;

import com.google.common.annotations.VisibleForTesting;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.metrics.gauges.OpenConnectionsGauge;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ChannelHandler.Sharable
public class ConnectionLimiterHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(ConnectionLimiterHandler.class);
    @NotNull
    private final MqttConnacker mqttConnacker;
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfigurationService;
    @NotNull
    private final OpenConnectionsGauge openConnectionsGauge;
    private volatile long maxConnections;
    private volatile long warnThreshold;

    @Inject
    public ConnectionLimiterHandler(@NotNull MqttConnacker mqttConnacker, @NotNull RestrictionsConfigurationService restrictionsConfigurationService, @NotNull OpenConnectionsGauge openConnectionsGauge) {
        this.mqttConnacker = mqttConnacker;
        this.restrictionsConfigurationService = restrictionsConfigurationService;
        this.openConnectionsGauge = openConnectionsGauge;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) throws Exception {
        long configuredCount = this.restrictionsConfigurationService.maxConnections();
        if (configuredCount > -1L) {
            this.warnThreshold = 90L * configuredCount / 100L;
            this.maxConnections = configuredCount;
        } else {
            ctx.pipeline().remove((ChannelHandler)this);
        }
        super.channelActive(ctx);
    }

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        if (msg instanceof CONNECT) {
            CONNECT connect = (CONNECT)msg;
            long currentCount = this.openConnectionsGauge.getValue().intValue();
            if (currentCount > this.maxConnections) {
                log.warn("The connection limit ({}) is reached. ClientID ({}) connection denied.", (Object)this.maxConnections, (Object)connect.getClientIdentifier());
                this.mqttConnacker.connackError(ctx.channel(), null, "The configured maximum amount of connections is reached", Mqtt5ConnAckReasonCode.QUOTA_EXCEEDED, null);
                return;
            }
            if (this.warnThreshold > 0L && currentCount >= this.warnThreshold) {
                log.warn("The amount of connections ({}) is close to its limit ({}).", (Object)currentCount, (Object)this.maxConnections);
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        super.channelRead(ctx, msg);
    }

    @VisibleForTesting
    long getWarnThreshold() {
        return this.warnThreshold;
    }

    @VisibleForTesting
    long getMaxConnections() {
        return this.maxConnections;
    }
}

