/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.subscribe;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.configuration.service.RestrictionsConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.auth.DefaultAuthorizationBehaviour;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extensions.packets.general.ModifiableDefaultPermissionsImpl;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.handler.publish.DefaultPermissionsEvaluator;
import com.hivemq.mqtt.handler.subscribe.retained.RetainedMessagesSender;
import com.hivemq.mqtt.handler.subscribe.retained.SendRetainedMessagesListener;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5SubAckReasonCode;
import com.hivemq.mqtt.message.suback.SUBACK;
import com.hivemq.mqtt.message.subscribe.SUBSCRIBE;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.persistence.clientsession.ClientSessionSubscriptionPersistence;
import com.hivemq.persistence.clientsession.SharedSubscriptionService;
import com.hivemq.persistence.clientsession.callback.SubscriptionResult;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import com.hivemq.util.Exceptions;
import com.hivemq.util.Topics;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IncomingSubscribeService {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(IncomingSubscribeService.class);
    @NotNull
    private static final Comparator<Topic> TOPIC_AND_QOS_COMPARATOR = new Comparator<Topic>(){

        @Override
        public int compare(Topic o1, Topic o2) {
            int strComp = o1.getTopic().compareTo(o2.getTopic());
            if (strComp == 0) {
                return o1.getQoS().getQosNumber() - o2.getQoS().getQosNumber();
            }
            return strComp;
        }
    };
    @NotNull
    private final ClientSessionSubscriptionPersistence clientSessionSubscriptionPersistence;
    @NotNull
    private final RetainedMessagePersistence retainedMessagePersistence;
    @NotNull
    private final SharedSubscriptionService sharedSubscriptionService;
    @NotNull
    private final RetainedMessagesSender retainedMessagesSender;
    @NotNull
    private final MqttConfigurationService mqttConfigurationService;
    @NotNull
    private final RestrictionsConfigurationService restrictionsConfigurationService;
    @NotNull
    private final MqttServerDisconnector mqttServerDisconnector;

    @Inject
    IncomingSubscribeService(@NotNull ClientSessionSubscriptionPersistence clientSessionSubscriptionPersistence, @NotNull RetainedMessagePersistence retainedMessagePersistence, @NotNull SharedSubscriptionService sharedSubscriptionService, @NotNull RetainedMessagesSender retainedMessagesSender, @NotNull MqttConfigurationService mqttConfigurationService, @NotNull RestrictionsConfigurationService restrictionsConfigurationService, @NotNull MqttServerDisconnector mqttServerDisconnector) {
        this.clientSessionSubscriptionPersistence = clientSessionSubscriptionPersistence;
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.sharedSubscriptionService = sharedSubscriptionService;
        this.retainedMessagesSender = retainedMessagesSender;
        this.mqttConfigurationService = mqttConfigurationService;
        this.restrictionsConfigurationService = restrictionsConfigurationService;
        this.mqttServerDisconnector = mqttServerDisconnector;
    }

    public void processSubscribe(@NotNull ChannelHandlerContext ctx, @NotNull SUBSCRIBE msg, boolean authorizersPresent) {
        this.processSubscribe(ctx, msg, new Mqtt5SubAckReasonCode[msg.getTopics().size()], new String[msg.getTopics().size()], authorizersPresent);
    }

    public void processSubscribe(@NotNull ChannelHandlerContext ctx, @NotNull SUBSCRIBE msg, @NotNull Mqtt5SubAckReasonCode[] providedCodes, @NotNull String[] reasonStrings, boolean authorizersPresent) {
        if (!this.hasOnlyValidSubscriptions(ctx, msg)) {
            return;
        }
        this.authorizeSubscriptions(ctx, msg, providedCodes, reasonStrings, authorizersPresent);
    }

    private void authorizeSubscriptions(@NotNull ChannelHandlerContext ctx, @NotNull SUBSCRIBE msg, @NotNull Mqtt5SubAckReasonCode[] providedCodes, @NotNull String[] reasonStrings, boolean authorizersPresent) {
        ModifiableDefaultPermissions permissions = ClientConnection.of(ctx.channel()).getAuthPermissions();
        ModifiableDefaultPermissionsImpl defaultPermissions = (ModifiableDefaultPermissionsImpl)permissions;
        for (int i = 0; i < msg.getTopics().size(); ++i) {
            if (providedCodes[i] != null) continue;
            if (authorizersPresent && (defaultPermissions == null || defaultPermissions.asList().size() < 1 && defaultPermissions.getDefaultBehaviour() == DefaultAuthorizationBehaviour.ALLOW && !defaultPermissions.isDefaultAuthorizationBehaviourOverridden())) {
                providedCodes[i] = Mqtt5SubAckReasonCode.NOT_AUTHORIZED;
                continue;
            }
            Topic subscription = (Topic)msg.getTopics().get(i);
            if (DefaultPermissionsEvaluator.checkSubscription(permissions, subscription)) continue;
            providedCodes[i] = Mqtt5SubAckReasonCode.NOT_AUTHORIZED;
            reasonStrings[i] = "Not authorized to subscribe to topic '" + subscription.getTopic() + "' with QoS '" + subscription.getQoS().getQosNumber() + "'";
        }
        StringBuilder reasonStringBuilder = new StringBuilder();
        for (String reasonString : reasonStrings) {
            if (reasonString == null || reasonString.isEmpty()) continue;
            reasonStringBuilder.append(reasonString).append(". ");
        }
        this.persistSubscriptionForClient(ctx, msg, providedCodes, reasonStringBuilder.length() > 0 ? reasonStringBuilder.toString() : null);
    }

    private boolean hasOnlyValidSubscriptions(ChannelHandlerContext ctx, SUBSCRIBE msg) {
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        log.trace("Checking SUBSCRIBE message of client '{}' if topics are valid", (Object)clientConnection.getClientId());
        int maxTopicLength = this.restrictionsConfigurationService.maxTopicLength();
        for (Topic topic : msg.getTopics()) {
            String topicString = topic.getTopic();
            if (!Topics.isValidToSubscribe(topicString)) {
                String logMessage = "Disconnecting client '" + clientConnection.getClientId() + "'  (IP: {}) because it sent an invalid subscription: '" + topic.getTopic() + "'";
                this.mqttServerDisconnector.disconnect(ctx.channel(), logMessage, "Invalid subscription topic " + topic.getTopic(), Mqtt5DisconnectReasonCode.TOPIC_FILTER_INVALID, "Sent SUBSCRIBE with an invalid topic filter.");
                return false;
            }
            if (topicString.length() <= maxTopicLength) continue;
            String logMessage = "Disconnecting client '" + clientConnection.getClientId() + "'  (IP: {}) because it sent a subscription to a topic exceeding the maximum topic length: '" + topic.getTopic() + "'";
            this.mqttServerDisconnector.disconnect(ctx.channel(), logMessage, "Sent SUBSCRIBE for topic that exceeds maximum topic length", Mqtt5DisconnectReasonCode.TOPIC_FILTER_INVALID, "Sent SUBSCRIBE with an invalid topic filter.");
            return false;
        }
        return true;
    }

    private void persistSubscriptionForClient(@NotNull ChannelHandlerContext ctx, @NotNull SUBSCRIBE msg, @Nullable Mqtt5SubAckReasonCode[] providedCodes, @Nullable String reasonString) {
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        String clientId = clientConnection.getClientId();
        this.downgradeSharedSubscriptions(msg);
        ProtocolVersion mqttVersion = clientConnection.getProtocolVersion();
        Object[] answerCodes = providedCodes != null ? providedCodes : new Mqtt5SubAckReasonCode[msg.getTopics().size()];
        ImmutableList.Builder singleAddFutures = ImmutableList.builder();
        int futureCount = 0;
        HashSet<Topic> ignoredTopics = new HashSet<Topic>();
        for (int i = 0; i < msg.getTopics().size(); ++i) {
            Topic topic = (Topic)msg.getTopics().get(i);
            if (answerCodes[i] == null || answerCodes[i].getCode() < 128) {
                String logMessage;
                if (!this.mqttConfigurationService.wildcardSubscriptionsEnabled() && Topics.containsWildcard(topic.getTopic())) {
                    logMessage = "Client '" + clientId + "' (IP: {}) sent a SUBSCRIBE with a wildcard character in the topic filter '" + topic.getTopic() + "', although wildcard subscriptions are disabled. Disconnecting client.";
                    this.mqttServerDisconnector.disconnect(ctx.channel(), logMessage, "Sent a SUBSCRIBE with a wildcard character in the topic filter '" + topic.getTopic() + "', although wildcard subscriptions are disabled", Mqtt5DisconnectReasonCode.WILDCARD_SUBSCRIPTION_NOT_SUPPORTED, "Disconnecting client. SUBSCRIBE containing wildcard characters (#/+) was sent. The broker does not allow this.");
                    return;
                }
                if (!this.mqttConfigurationService.sharedSubscriptionsEnabled() && Topics.isSharedSubscriptionTopic(topic.getTopic())) {
                    logMessage = "Client '" + clientId + "' (IP: {}) sent a SUBSCRIBE, which matches a shared subscription '" + topic.getTopic() + "', although shared subscriptions are disabled. Disconnecting client.";
                    this.mqttServerDisconnector.disconnect(ctx.channel(), logMessage, "Sent a SUBSCRIBE, which matches a shared subscription '" + topic.getTopic() + "', although shared subscriptions are disabled", Mqtt5DisconnectReasonCode.SHARED_SUBSCRIPTION_NOT_SUPPORTED, "Disconnecting client. SUBSCRIBE containing shared subscriptions was sent. The broker does not allow this.");
                    return;
                }
                Mqtt5SubAckReasonCode reasonCode = Mqtt5SubAckReasonCode.fromCode(topic.getQoS().getQosNumber());
                Mqtt5SubAckReasonCode mqtt5SubAckReasonCode = answerCodes[i] = reasonCode != null ? reasonCode : Mqtt5SubAckReasonCode.UNSPECIFIED_ERROR;
            }
            if (answerCodes[i].getCode() < 128) continue;
            if (mqttVersion == ProtocolVersion.MQTTv3_1) {
                this.handleInsufficientPermissionsV31(ctx, topic);
                return;
            }
            ignoredTopics.add(topic);
            log.trace("Ignoring subscription for client [{}] and topic [{}] with qos [{}] because the client is not permitted", new Object[]{clientId, topic.getTopic(), topic.getQoS()});
        }
        Set<Topic> cleanedSubscriptions = this.getCleanedSubscriptions(msg);
        TreeSet cleanedSubscriptionsWithQoS = Sets.newTreeSet(TOPIC_AND_QOS_COMPARATOR);
        cleanedSubscriptionsWithQoS.addAll(cleanedSubscriptions);
        ListenableFuture<ImmutableList<SubscriptionResult>> batchedFuture = null;
        if (IncomingSubscribeService.batch(cleanedSubscriptions)) {
            cleanedSubscriptions.removeAll(ignoredTopics);
            batchedFuture = this.persistBatchedSubscriptions(clientId, msg, cleanedSubscriptions, mqttVersion, (Mqtt5SubAckReasonCode[])answerCodes);
            ++futureCount;
        } else {
            for (int i = 0; i < msg.getTopics().size(); ++i) {
                Topic topic = (Topic)msg.getTopics().get(i);
                if (ignoredTopics.contains(topic) || !cleanedSubscriptionsWithQoS.contains(topic)) continue;
                answerCodes[i] = Mqtt5SubAckReasonCode.fromCode(topic.getQoS().getQosNumber());
                SettableFuture settableFuture = SettableFuture.create();
                singleAddFutures.add((Object)settableFuture);
                ++futureCount;
                ListenableFuture<SubscriptionResult> addSubscriptionFuture = this.clientSessionSubscriptionPersistence.addSubscription(clientId, topic);
                Futures.addCallback(addSubscriptionFuture, (FutureCallback)new SubscribePersistenceCallback((SettableFuture<SubscriptionResult>)settableFuture, clientId, topic, mqttVersion, (Mqtt5SubAckReasonCode[])answerCodes, i), (Executor)MoreExecutors.directExecutor());
            }
        }
        log.trace("Applied all subscriptions for client [{}]", (Object)clientId);
        if (futureCount == 0) {
            ctx.channel().writeAndFlush((Object)new SUBACK(msg.getPacketIdentifier(), (List<Mqtt5SubAckReasonCode>)ImmutableList.copyOf((Object[])answerCodes), reasonString));
            return;
        }
        SettableFuture addResultsFuture = SettableFuture.create();
        if (batchedFuture != null) {
            addResultsFuture.setFuture(batchedFuture);
        } else {
            addResultsFuture.setFuture(Futures.allAsList((Iterable)singleAddFutures.build()));
        }
        this.sendSubackAndRetainedMessages(ctx, msg, (Mqtt5SubAckReasonCode[])answerCodes, (SettableFuture<List<SubscriptionResult>>)addResultsFuture, ignoredTopics, reasonString);
    }

    private void sendSubackAndRetainedMessages(final ChannelHandlerContext ctx, final @NotNull SUBSCRIBE msg, final @NotNull Mqtt5SubAckReasonCode[] answerCodes, @NotNull SettableFuture<List<SubscriptionResult>> addResultsFuture, final @NotNull Set<Topic> ignoredTopics, final @Nullable String reasonString) {
        Futures.addCallback(addResultsFuture, (FutureCallback)new FutureCallback<List<SubscriptionResult>>(){

            public void onSuccess(@Nullable List<SubscriptionResult> subscriptionResults) {
                ChannelFuture future = ctx.channel().writeAndFlush((Object)new SUBACK(msg.getPacketIdentifier(), (List<Mqtt5SubAckReasonCode>)ImmutableList.copyOf((Object[])answerCodes), reasonString));
                if (subscriptionResults != null) {
                    future.addListener((GenericFutureListener)new SendRetainedMessagesListener(subscriptionResults, ignoredTopics, IncomingSubscribeService.this.retainedMessagePersistence, IncomingSubscribeService.this.retainedMessagesSender));
                }
            }

            public void onFailure(@NotNull Throwable throwable) {
                ctx.channel().disconnect();
            }
        }, (Executor)ctx.executor());
    }

    @NotNull
    private Set<Topic> getCleanedSubscriptions(SUBSCRIBE msg) {
        ImmutableList<Topic> topics = msg.getTopics();
        int size = topics.size();
        if (size < 2) {
            return Sets.newHashSet(topics);
        }
        HashSet cleanedTopics = Sets.newHashSetWithExpectedSize((int)size);
        for (Topic topic : topics) {
            if (cleanedTopics.add(topic)) continue;
            cleanedTopics.remove(topic);
            cleanedTopics.add(topic);
        }
        return cleanedTopics;
    }

    @VisibleForTesting
    static boolean batch(@NotNull Set<Topic> topics) {
        return topics.size() >= 2;
    }

    @NotNull
    private ListenableFuture<ImmutableList<SubscriptionResult>> persistBatchedSubscriptions(@NotNull String clientId, @NotNull SUBSCRIBE msg, @NotNull Set<Topic> cleanedSubscriptions, @NotNull ProtocolVersion mqttVersion, @NotNull Mqtt5SubAckReasonCode[] answerCodes) {
        SettableFuture settableFuture = SettableFuture.create();
        ImmutableSet topics = ImmutableSet.copyOf(cleanedSubscriptions);
        ListenableFuture<ImmutableList<SubscriptionResult>> addSubscriptionFuture = this.clientSessionSubscriptionPersistence.addSubscriptions(clientId, (ImmutableSet<Topic>)topics);
        Futures.addCallback(addSubscriptionFuture, (FutureCallback)new SubscribePersistenceBatchedCallback((SettableFuture<ImmutableList<SubscriptionResult>>)settableFuture, clientId, msg, mqttVersion, answerCodes), (Executor)MoreExecutors.directExecutor());
        return settableFuture;
    }

    private void handleInsufficientPermissionsV31(@NotNull ChannelHandlerContext ctx, @NotNull Topic topic) {
        ClientConnection clientConnection = ClientConnection.of(ctx.channel());
        log.debug("MQTT v3.1 Client '{}' (IP: {}) is not authorized to subscribe to topic '{}' with QoS '{}'. Disconnecting client.", new Object[]{clientConnection.getClientId(), clientConnection.getChannelIP().orElse("UNKNOWN"), topic.getTopic(), topic.getQoS().getQosNumber()});
        this.mqttServerDisconnector.disconnect(ctx.channel(), null, "Not authorized to subscribe to topic '" + topic.getTopic() + "', QoS '" + topic.getQoS() + "'", Mqtt5DisconnectReasonCode.NOT_AUTHORIZED, null);
    }

    private void downgradeSharedSubscriptions(@NotNull SUBSCRIBE subscribe) {
        for (Topic topic : subscribe.getTopics()) {
            SharedSubscriptionService.SharedSubscription sharedSubscription = SharedSubscriptionService.checkForSharedSubscription(topic.getTopic());
            if (sharedSubscription == null || topic.getQoS().getQosNumber() <= 1) continue;
            topic.setQoS(QoS.AT_LEAST_ONCE);
        }
    }

    private static class SubscribePersistenceCallback
    implements FutureCallback<SubscriptionResult> {
        @NotNull
        private final SettableFuture<SubscriptionResult> settableFuture;
        @NotNull
        private final String clientId;
        @NotNull
        private final Topic topic;
        @NotNull
        private final ProtocolVersion mqttVersion;
        @NotNull
        private final Mqtt5SubAckReasonCode[] answerCodes;
        private final int index;

        public SubscribePersistenceCallback(@NotNull SettableFuture<SubscriptionResult> settableFuture, @NotNull String clientId, @NotNull Topic topic, @NotNull ProtocolVersion mqttVersion, @NotNull Mqtt5SubAckReasonCode[] answerCodes, int index) {
            this.settableFuture = settableFuture;
            this.clientId = clientId;
            this.topic = topic;
            this.mqttVersion = mqttVersion;
            this.answerCodes = answerCodes;
            this.index = index;
        }

        public void onSuccess(@Nullable SubscriptionResult subscriptionResult) {
            this.settableFuture.set((Object)subscriptionResult);
            log.trace("Adding subscriptions for client [{}] and topic [{}] with qos [{}]", new Object[]{this.clientId, this.topic.getTopic(), this.topic.getQoS()});
        }

        public void onFailure(@NotNull Throwable throwable) {
            if (this.mqttVersion == ProtocolVersion.MQTTv3_1_1) {
                Exceptions.rethrowError("Unable to persist subscription to topic " + this.topic + " for client " + this.clientId + ".", throwable);
                this.answerCodes[this.index] = Mqtt5SubAckReasonCode.UNSPECIFIED_ERROR;
                this.settableFuture.set(null);
            } else {
                this.settableFuture.setException(throwable);
            }
        }
    }

    private static class SubscribePersistenceBatchedCallback
    implements FutureCallback<ImmutableList<SubscriptionResult>> {
        @NotNull
        private final SettableFuture<ImmutableList<SubscriptionResult>> settableFuture;
        @NotNull
        private final String clientId;
        @NotNull
        private final SUBSCRIBE msg;
        @NotNull
        private final ProtocolVersion mqttVersion;
        @NotNull
        private final Mqtt5SubAckReasonCode[] answerCodes;

        public SubscribePersistenceBatchedCallback(@NotNull SettableFuture<ImmutableList<SubscriptionResult>> settableFuture, @NotNull String clientId, @NotNull SUBSCRIBE msg, @NotNull ProtocolVersion mqttVersion, @NotNull Mqtt5SubAckReasonCode[] answerCodes) {
            this.settableFuture = settableFuture;
            this.clientId = clientId;
            this.msg = msg;
            this.mqttVersion = mqttVersion;
            this.answerCodes = answerCodes;
        }

        public void onSuccess(@Nullable ImmutableList<SubscriptionResult> subscriptionResult) {
            this.settableFuture.set(subscriptionResult);
            log.trace("Adding subscriptions for client [{}] and topics [{}]", (Object)this.clientId, this.msg.getTopics());
        }

        public void onFailure(@NotNull Throwable throwable) {
            if (this.mqttVersion == ProtocolVersion.MQTTv3_1_1) {
                Exceptions.rethrowError("Unable to persist subscription to topics " + this.msg.getTopics() + " for client " + this.clientId + ".", throwable);
                for (int i = 0; i < this.answerCodes.length; ++i) {
                    this.answerCodes[i] = Mqtt5SubAckReasonCode.UNSPECIFIED_ERROR;
                }
                this.settableFuture.set(null);
            } else {
                this.settableFuture.setException(throwable);
            }
        }
    }
}

