/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.handler.subscribe.retained;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.mqtt.handler.publish.PublishWriteFailedListener;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.pool.FreePacketIdRanges;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.mqtt.message.publish.PublishWithFuture;
import com.hivemq.mqtt.message.subscribe.Topic;
import com.hivemq.persistence.RetainedMessage;
import com.hivemq.persistence.clientqueue.ClientQueuePersistence;
import com.hivemq.persistence.retained.RetainedMessagePersistence;
import com.hivemq.persistence.util.FutureUtils;
import io.netty.channel.Channel;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RetainedMessagesSender {
    private static final Logger log = LoggerFactory.getLogger(RetainedMessagesSender.class);
    private static final ClosedChannelException CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
    @NotNull
    private final HivemqId hiveMQId;
    @NotNull
    private final RetainedMessagePersistence retainedMessagePersistence;
    @NotNull
    private final ClientQueuePersistence clientQueuePersistence;
    @NotNull
    private final MqttConfigurationService mqttConfigurationService;

    @Inject
    public RetainedMessagesSender(@NotNull HivemqId hiveMQId, @NotNull RetainedMessagePersistence retainedMessagePersistence, @NotNull ClientQueuePersistence clientQueuePersistence, @NotNull MqttConfigurationService mqttConfigurationService) {
        this.hiveMQId = hiveMQId;
        this.retainedMessagePersistence = retainedMessagePersistence;
        this.clientQueuePersistence = clientQueuePersistence;
        this.mqttConfigurationService = mqttConfigurationService;
    }

    @NotNull
    public ListenableFuture<Void> writeRetainedMessages(@NotNull Channel channel, Topic ... subscribedTopics) {
        if (subscribedTopics == null) {
            return Futures.immediateFuture(null);
        }
        String clientId = ClientConnection.of(channel).getClientId();
        ImmutableList.Builder retainedMessageFutures = ImmutableList.builder();
        for (Topic topic : subscribedTopics) {
            retainedMessageFutures.add(this.retainedMessagePersistence.get(topic.getTopic()));
        }
        ListenableFuture retainedMessagesFuture = Futures.allAsList((Iterable)retainedMessageFutures.build());
        SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback((ListenableFuture)retainedMessagesFuture, (FutureCallback)new SendRetainedMessageCallback(subscribedTopics, this.hiveMQId, clientId, (SettableFuture<Void>)resultFuture, channel, this.clientQueuePersistence, this.mqttConfigurationService), (Executor)channel.eventLoop());
        return resultFuture;
    }

    static {
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }

    private static class SendRetainedMessageCallback
    implements FutureCallback<List<RetainedMessage>> {
        @NotNull
        private final Topic[] subscribedTopics;
        @NotNull
        private final HivemqId hivemqId;
        @NotNull
        private final String clientId;
        @NotNull
        private final SettableFuture<Void> resultFuture;
        @NotNull
        private final Channel channel;
        @NotNull
        private final ClientQueuePersistence clientQueuePersistence;
        @NotNull
        private final MqttConfigurationService mqttConfigurationService;

        SendRetainedMessageCallback(@NotNull Topic[] subscribedTopics, @NotNull HivemqId hivemqId, @NotNull String clientId, @NotNull SettableFuture<Void> resultFuture, @NotNull Channel channel, @NotNull ClientQueuePersistence clientQueuePersistence, @NotNull MqttConfigurationService mqttConfigurationService) {
            this.subscribedTopics = subscribedTopics;
            this.hivemqId = hivemqId;
            this.clientId = clientId;
            this.resultFuture = resultFuture;
            this.channel = channel;
            this.clientQueuePersistence = clientQueuePersistence;
            this.mqttConfigurationService = mqttConfigurationService;
        }

        public void onSuccess(List<RetainedMessage> retainedMessages) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < retainedMessages.size(); ++i) {
                RetainedMessage retainedMessage = retainedMessages.get(i);
                if (retainedMessage == null) continue;
                Topic subscribedTopic = this.subscribedTopics[i];
                QoS qos = QoS.getMinQoS(subscribedTopic.getQoS(), retainedMessage.getQos());
                ImmutableIntArray subscriptionIdentifiers = subscribedTopic.getSubscriptionIdentifier() != null ? ImmutableIntArray.of((int)subscribedTopic.getSubscriptionIdentifier()) : ImmutableIntArray.of();
                PUBLISHFactory.Mqtt5Builder publishBuilder = new PUBLISHFactory.Mqtt5Builder().withTimestamp(System.currentTimeMillis()).withHivemqId(this.hivemqId.get()).withPayload(retainedMessage.getMessage()).withPublishId(retainedMessage.getPublishId()).withMessageExpiryInterval(retainedMessage.getMessageExpiryInterval()).withTopic(subscribedTopic.getTopic()).withRetain(true).withDuplicateDelivery(false).withQoS(qos).withOnwardQos(qos).withUserProperties(retainedMessage.getUserProperties()).withResponseTopic(retainedMessage.getResponseTopic()).withContentType(retainedMessage.getContentType()).withCorrelationData(retainedMessage.getCorrelationData()).withPayloadFormatIndicator(retainedMessage.getPayloadFormatIndicator()).withSubscriptionIdentifiers(subscriptionIdentifiers);
                builder.add((Object)publishBuilder.build());
            }
            this.sendOutMessages((List<PUBLISH>)builder.build());
        }

        private void sendOutMessages(@NotNull List<PUBLISH> retainedPublishes) {
            if (!this.channel.isActive()) {
                this.resultFuture.setException((Throwable)CLOSED_CHANNEL_EXCEPTION);
                return;
            }
            if (log.isTraceEnabled()) {
                for (Topic topic : this.subscribedTopics) {
                    log.trace("Sending retained message with topic [{}] for client [{}]", (Object)topic.getTopic(), (Object)this.clientId);
                }
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableList.Builder futures = ImmutableList.builder();
            for (PUBLISH publish : retainedPublishes) {
                if (publish.getQoS() == QoS.AT_MOST_ONCE) {
                    futures.add(this.sendQos0PublishDirectly(publish));
                    continue;
                }
                builder.add((Object)publish);
            }
            ImmutableList qos1and2Messages = builder.build();
            if (qos1and2Messages.isEmpty()) {
                this.resultFuture.setFuture(FutureUtils.voidFutureFromList((ImmutableList<ListenableFuture<Void>>)futures.build()));
                return;
            }
            Long queueLimit = ClientConnection.of(this.channel).getQueueSizeMaximum();
            futures.add(this.clientQueuePersistence.add(this.clientId, false, (List<PUBLISH>)qos1and2Messages, true, (long)Objects.requireNonNullElseGet(queueLimit, this.mqttConfigurationService::maxQueuedMessages)));
            this.resultFuture.setFuture(FutureUtils.voidFutureFromList((ImmutableList<ListenableFuture<Void>>)futures.build()));
        }

        private ListenableFuture<Void> sendQos0PublishDirectly(final @NotNull PUBLISH qos0Publish) {
            final SettableFuture resultFuture = SettableFuture.create();
            SettableFuture publishFuture = SettableFuture.create();
            Futures.addCallback((ListenableFuture)publishFuture, (FutureCallback)new FutureCallback<PublishStatus>(){

                public void onSuccess(@Nullable PublishStatus status) {
                    if (status == PublishStatus.DELIVERED) {
                        resultFuture.set(null);
                    } else {
                        resultFuture.setException((Throwable)new ClosedChannelException());
                    }
                    if (qos0Publish.getPacketIdentifier() != 0) {
                        FreePacketIdRanges freePacketIdRanges = ClientConnection.of(channel).getFreePacketIdRanges();
                        freePacketIdRanges.returnId(qos0Publish.getPacketIdentifier());
                    }
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t instanceof CancellationException) {
                        return;
                    }
                }
            }, (Executor)MoreExecutors.directExecutor());
            PublishWithFuture message = new PublishWithFuture(qos0Publish, (SettableFuture<PublishStatus>)publishFuture, false);
            this.channel.writeAndFlush((Object)message).addListener((GenericFutureListener)new PublishWriteFailedListener((SettableFuture<PublishStatus>)publishFuture));
            return resultFuture;
        }

        public void onFailure(@NotNull Throwable throwable) {
            this.resultFuture.setException(throwable);
        }
    }
}

