/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.message.reason;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.packets.publish.AckReasonCode;
import com.hivemq.mqtt.message.reason.Mqtt5ReasonCode;
import com.hivemq.mqtt.message.reason.MqttCommonReasonCode;

public enum Mqtt5PubAckReasonCode implements Mqtt5ReasonCode
{
    SUCCESS(MqttCommonReasonCode.SUCCESS),
    NO_MATCHING_SUBSCRIBERS(MqttCommonReasonCode.NO_MATCHING_SUBSCRIBERS),
    UNSPECIFIED_ERROR(MqttCommonReasonCode.UNSPECIFIED_ERROR),
    IMPLEMENTATION_SPECIFIC_ERROR(MqttCommonReasonCode.IMPLEMENTATION_SPECIFIC_ERROR),
    NOT_AUTHORIZED(MqttCommonReasonCode.NOT_AUTHORIZED),
    TOPIC_NAME_INVALID(MqttCommonReasonCode.TOPIC_NAME_INVALID),
    PACKET_IDENTIFIER_IN_USE(MqttCommonReasonCode.PACKET_IDENTIFIER_IN_USE),
    QUOTA_EXCEEDED(MqttCommonReasonCode.QUOTA_EXCEEDED),
    PAYLOAD_FORMAT_INVALID(MqttCommonReasonCode.PAYLOAD_FORMAT_INVALID);

    @NotNull
    private static final Mqtt5PubAckReasonCode[] VALUES;
    private final int code;
    @NotNull
    private final AckReasonCode ackReasonCode;
    @NotNull
    private static final @NotNull Mqtt5PubAckReasonCode @NotNull [] ACK_LOOKUP;

    private Mqtt5PubAckReasonCode(int code) {
        this.code = code;
        this.ackReasonCode = AckReasonCode.valueOf((String)this.name());
    }

    private Mqtt5PubAckReasonCode(MqttCommonReasonCode reasonCode) {
        this(reasonCode.getCode());
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @NotNull
    public AckReasonCode toAckReasonCode() {
        return this.ackReasonCode;
    }

    @Nullable
    public static Mqtt5PubAckReasonCode fromCode(int code) {
        for (Mqtt5PubAckReasonCode reasonCode : VALUES) {
            if (reasonCode.code != code) continue;
            return reasonCode;
        }
        return null;
    }

    @NotNull
    public static Mqtt5PubAckReasonCode from(@NotNull AckReasonCode reasonCode) {
        return ACK_LOOKUP[reasonCode.ordinal()];
    }

    @Override
    public boolean canBeSentByClient() {
        return this != NO_MATCHING_SUBSCRIBERS;
    }

    static {
        VALUES = Mqtt5PubAckReasonCode.values();
        ACK_LOOKUP = new Mqtt5PubAckReasonCode[AckReasonCode.values().length];
        Mqtt5PubAckReasonCode[] mqtt5PubAckReasonCodeArray = VALUES;
        int n = mqtt5PubAckReasonCodeArray.length;
        for (int i = 0; i < n; ++i) {
            Mqtt5PubAckReasonCode reasonCode;
            Mqtt5PubAckReasonCode.ACK_LOOKUP[reasonCode.ackReasonCode.ordinal()] = reasonCode = mqtt5PubAckReasonCodeArray[i];
        }
    }
}

