/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.mqtt.services;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.publish.PublishStatus;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.publish.PUBLISHFactory;
import com.hivemq.mqtt.services.PublishDistributor;
import com.hivemq.mqtt.services.StandardPublishCallback;
import com.hivemq.mqtt.topic.SubscriberWithIdentifiers;
import com.hivemq.persistence.SingleWriterService;
import com.hivemq.persistence.clientqueue.ClientQueuePersistence;
import com.hivemq.persistence.clientsession.ClientSession;
import com.hivemq.persistence.clientsession.ClientSessionPersistence;
import com.hivemq.persistence.util.FutureUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PublishDistributorImpl
implements PublishDistributor {
    @NotNull
    private final ClientQueuePersistence clientQueuePersistence;
    @NotNull
    private final ClientSessionPersistence clientSessionPersistence;
    private final SingleWriterService singleWriterService;
    @NotNull
    private final MqttConfigurationService mqttConfigurationService;

    @Inject
    public PublishDistributorImpl(@NotNull ClientQueuePersistence clientQueuePersistence, @NotNull ClientSessionPersistence clientSessionPersistence, @NotNull SingleWriterService singleWriterService, @NotNull MqttConfigurationService mqttConfigurationService) {
        this.clientQueuePersistence = clientQueuePersistence;
        this.clientSessionPersistence = clientSessionPersistence;
        this.singleWriterService = singleWriterService;
        this.mqttConfigurationService = mqttConfigurationService;
    }

    @Override
    @NotNull
    public ListenableFuture<Void> distributeToNonSharedSubscribers(@NotNull Map<String, SubscriberWithIdentifiers> subscribers, @NotNull PUBLISH publish, @NotNull ExecutorService executorService) {
        ImmutableList.Builder publishResultFutureBuilder = ImmutableList.builder();
        for (Map.Entry<String, SubscriberWithIdentifiers> entry : subscribers.entrySet()) {
            SubscriberWithIdentifiers subscriber = entry.getValue();
            ListenableFuture<PublishStatus> publishFuture = this.sendMessageToSubscriber(publish, entry.getKey(), subscriber.getQos(), false, subscriber.isRetainAsPublished(), subscriber.getSubscriptionIdentifier());
            SettableFuture publishFinishedFuture = SettableFuture.create();
            publishResultFutureBuilder.add((Object)publishFinishedFuture);
            Futures.addCallback(publishFuture, (FutureCallback)new StandardPublishCallback(entry.getKey(), publish, (SettableFuture<Void>)publishFinishedFuture), (Executor)executorService);
        }
        return FutureUtils.voidFutureFromList((ImmutableList<ListenableFuture<Void>>)publishResultFutureBuilder.build());
    }

    @Override
    @NotNull
    public ListenableFuture<Void> distributeToSharedSubscribers(@NotNull Set<String> sharedSubscribers, @NotNull PUBLISH publish, @NotNull ExecutorService executorService) {
        ImmutableList.Builder publishResultFutureBuilder = ImmutableList.builder();
        for (String sharedSubscriber : sharedSubscribers) {
            SettableFuture publishFinishedFuture = SettableFuture.create();
            ListenableFuture<PublishStatus> future = this.sendMessageToSubscriber(publish, sharedSubscriber, publish.getQoS().getQosNumber(), true, true, null);
            publishResultFutureBuilder.add((Object)publishFinishedFuture);
            Futures.addCallback(future, (FutureCallback)new StandardPublishCallback(sharedSubscriber, publish, (SettableFuture<Void>)publishFinishedFuture), (Executor)executorService);
        }
        return FutureUtils.voidFutureFromList((ImmutableList<ListenableFuture<Void>>)publishResultFutureBuilder.build());
    }

    @Override
    @NotNull
    public ListenableFuture<PublishStatus> sendMessageToSubscriber(@NotNull PUBLISH publish, @NotNull String clientId, int subscriptionQos, boolean sharedSubscription, boolean retainAsPublished, @Nullable ImmutableIntArray subscriptionIdentifier) {
        return this.handlePublish(publish, clientId, subscriptionQos, sharedSubscription, retainAsPublished, subscriptionIdentifier);
    }

    @NotNull
    private ListenableFuture<PublishStatus> handlePublish(@NotNull PUBLISH publish, @NotNull String client, int subscriptionQos, boolean sharedSubscription, boolean retainAsPublished, @Nullable ImmutableIntArray subscriptionIdentifier) {
        boolean clientConnected;
        if (sharedSubscription) {
            return this.queuePublish(client, publish, subscriptionQos, true, retainAsPublished, subscriptionIdentifier, null);
        }
        boolean qos0Message = Math.min(subscriptionQos, publish.getQoS().getQosNumber()) == 0;
        ClientSession clientSession = this.clientSessionPersistence.getSession(client, false);
        boolean bl = clientConnected = clientSession != null && clientSession.isConnected();
        if (qos0Message && !clientConnected) {
            return Futures.immediateFuture((Object)((Object)PublishStatus.NOT_CONNECTED));
        }
        if (clientSession == null) {
            return Futures.immediateFuture((Object)((Object)PublishStatus.NOT_CONNECTED));
        }
        return this.queuePublish(client, publish, subscriptionQos, false, retainAsPublished, subscriptionIdentifier, clientSession.getQueueLimit());
    }

    @NotNull
    private SettableFuture<PublishStatus> queuePublish(@NotNull String client, @NotNull PUBLISH publish, int subscriptionQos, boolean shared, boolean retainAsPublished, @Nullable ImmutableIntArray subscriptionIdentifier, @Nullable Long queueLimit) {
        ListenableFuture<Void> future = this.clientQueuePersistence.add(client, shared, this.createPublish(publish, subscriptionQos, retainAsPublished, subscriptionIdentifier), false, (long)Objects.requireNonNullElseGet(queueLimit, this.mqttConfigurationService::maxQueuedMessages));
        final SettableFuture statusFuture = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback<Void>(){

            public void onSuccess(Void result) {
                statusFuture.set((Object)PublishStatus.DELIVERED);
            }

            public void onFailure(Throwable t) {
                statusFuture.set((Object)PublishStatus.FAILED);
            }
        }, (Executor)this.singleWriterService.callbackExecutor(client));
        return statusFuture;
    }

    @NotNull
    private PUBLISH createPublish(@NotNull PUBLISH publish, int subscriptionQos, boolean retainAsPublished, @Nullable ImmutableIntArray subscriptionIdentifier) {
        ImmutableIntArray identifiers = subscriptionIdentifier == null ? ImmutableIntArray.of() : subscriptionIdentifier;
        PUBLISHFactory.Mqtt5Builder builder = new PUBLISHFactory.Mqtt5Builder().fromPublish(publish).withRetain(publish.isRetain() && retainAsPublished).withSubscriptionIdentifiers(identifiers);
        int qos = Math.min(publish.getOnwardQoS().getQosNumber(), subscriptionQos);
        builder.withQoS(QoS.valueOf(qos));
        if (qos == 0) {
            builder.withPacketIdentifier(0);
        }
        return builder.build();
    }
}

