/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.migration.meta.PersistenceType;
import com.hivemq.persistence.clientqueue.ClientQueueLocalPersistence;
import com.hivemq.persistence.clientqueue.ClientQueueXodusLocalPersistence;
import com.hivemq.persistence.ioc.LocalPersistenceRocksDBModule;
import com.hivemq.persistence.ioc.provider.local.ClientSessionLocalProvider;
import com.hivemq.persistence.ioc.provider.local.ClientSessionSubscriptionLocalProvider;
import com.hivemq.persistence.local.ClientSessionLocalPersistence;
import com.hivemq.persistence.local.ClientSessionSubscriptionLocalPersistence;
import com.hivemq.persistence.local.xodus.RetainedMessageXodusLocalPersistence;
import com.hivemq.persistence.local.xodus.clientsession.ClientSessionSubscriptionXodusLocalPersistence;
import com.hivemq.persistence.local.xodus.clientsession.ClientSessionXodusLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadLocalPersistence;
import com.hivemq.persistence.payload.PublishPayloadXodusLocalPersistence;
import com.hivemq.persistence.retained.RetainedMessageLocalPersistence;
import javax.inject.Singleton;

class LocalPersistenceFileModule
extends SingletonModule<Class<LocalPersistenceFileModule>> {
    @NotNull
    private final Injector persistenceInjector;
    @NotNull
    private final PersistenceType payloadPersistenceType;
    @NotNull
    private final PersistenceType retainedPersistenceType;

    public LocalPersistenceFileModule(@NotNull Injector persistenceInjector) {
        super(LocalPersistenceFileModule.class);
        this.persistenceInjector = persistenceInjector;
        this.payloadPersistenceType = InternalConfigurations.PAYLOAD_PERSISTENCE_TYPE.get();
        this.retainedPersistenceType = InternalConfigurations.RETAINED_MESSAGE_PERSISTENCE_TYPE.get();
    }

    protected void configure() {
        if (this.payloadPersistenceType == PersistenceType.FILE) {
            this.bindLocalPersistence(PublishPayloadLocalPersistence.class, PublishPayloadXodusLocalPersistence.class, null);
        }
        if (this.retainedPersistenceType == PersistenceType.FILE) {
            this.bindLocalPersistence(RetainedMessageLocalPersistence.class, RetainedMessageXodusLocalPersistence.class, null);
        }
        if (this.payloadPersistenceType == PersistenceType.FILE_NATIVE || this.retainedPersistenceType == PersistenceType.FILE_NATIVE) {
            this.install((Module)new LocalPersistenceRocksDBModule(this.persistenceInjector));
        }
        this.bindLocalPersistence(ClientSessionLocalPersistence.class, ClientSessionXodusLocalPersistence.class, ClientSessionLocalProvider.class);
        this.bindLocalPersistence(ClientSessionSubscriptionLocalPersistence.class, ClientSessionSubscriptionXodusLocalPersistence.class, ClientSessionSubscriptionLocalProvider.class);
        this.bindLocalPersistence(ClientQueueLocalPersistence.class, ClientQueueXodusLocalPersistence.class, null);
    }

    private void bindLocalPersistence(@NotNull Class localPersistenceClass, @NotNull Class localPersistenceImplClass, @Nullable Class localPersistenceProviderClass) {
        Object instance = this.persistenceInjector.getInstance(localPersistenceImplClass);
        if (instance != null) {
            this.bind(localPersistenceImplClass).toInstance(instance);
            this.bind(localPersistenceClass).toInstance(instance);
        } else if (localPersistenceProviderClass != null) {
            this.bind(localPersistenceClass).toProvider(localPersistenceProviderClass).in(Singleton.class);
        } else {
            this.bind(localPersistenceClass).to(localPersistenceImplClass).in(Singleton.class);
        }
    }
}

