/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.ioc;

import com.codahale.metrics.MetricRegistry;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.inject.Module;
import com.hivemq.bootstrap.ioc.SingletonModule;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.service.PersistenceConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.metrics.MetricsHolder;
import com.hivemq.metrics.ioc.provider.MetricsHolderProvider;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.dropping.MessageDroppedServiceProvider;
import com.hivemq.persistence.PersistenceStartup;
import com.hivemq.persistence.PersistenceStartupShutdownHookInstaller;
import com.hivemq.persistence.ioc.LocalPersistenceMemoryModule;
import com.hivemq.persistence.ioc.PersistenceMigrationFileModule;
import com.hivemq.persistence.ioc.annotation.PayloadPersistence;
import com.hivemq.persistence.ioc.provider.local.PayloadPersistenceScheduledExecutorProvider;
import com.hivemq.persistence.payload.PublishPayloadNoopPersistenceImpl;
import com.hivemq.persistence.payload.PublishPayloadPersistence;
import com.hivemq.persistence.payload.PublishPayloadPersistenceImpl;
import javax.inject.Singleton;

public class PersistenceMigrationModule
extends SingletonModule<Class<PersistenceMigrationModule>> {
    @NotNull
    private final MetricRegistry metricRegistry;
    @NotNull
    private final PersistenceConfigurationService persistenceConfigurationService;

    public PersistenceMigrationModule(@NotNull MetricRegistry metricRegistry, @NotNull PersistenceConfigurationService persistenceConfigurationService) {
        super(PersistenceMigrationModule.class);
        this.metricRegistry = metricRegistry;
        this.persistenceConfigurationService = persistenceConfigurationService;
    }

    protected void configure() {
        this.bind(ShutdownHooks.class).asEagerSingleton();
        this.bind(PersistenceStartup.class).asEagerSingleton();
        this.bind(PersistenceStartupShutdownHookInstaller.class).asEagerSingleton();
        if (this.persistenceConfigurationService.getMode() == PersistenceConfigurationService.PersistenceMode.FILE) {
            this.install((Module)new PersistenceMigrationFileModule());
        } else {
            this.install((Module)new LocalPersistenceMemoryModule(null));
        }
        if (this.persistenceConfigurationService.getMode() == PersistenceConfigurationService.PersistenceMode.IN_MEMORY) {
            this.bind(PublishPayloadPersistence.class).to(PublishPayloadNoopPersistenceImpl.class);
        } else {
            this.bind(PublishPayloadPersistence.class).to(PublishPayloadPersistenceImpl.class);
        }
        this.bind(MetricRegistry.class).toInstance((Object)this.metricRegistry);
        this.bind(MetricsHolder.class).toProvider(MetricsHolderProvider.class).asEagerSingleton();
        this.bind(ListeningScheduledExecutorService.class).annotatedWith(PayloadPersistence.class).toProvider(PayloadPersistenceScheduledExecutorProvider.class).in(LazySingleton.class);
        this.bind(MessageDroppedService.class).toProvider(MessageDroppedServiceProvider.class).in(Singleton.class);
    }
}

