/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.memory;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.ImmutableIntArray;
import com.hivemq.annotations.ExecuteInSingleWriter;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.configuration.service.MqttConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.metrics.HiveMQMetrics;
import com.hivemq.mqtt.message.MessageWithID;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.publish.PUBLISH;
import com.hivemq.mqtt.message.pubrel.PUBREL;
import com.hivemq.mqtt.message.reason.Mqtt5PubRelReasonCode;
import com.hivemq.persistence.clientqueue.ClientQueueLocalPersistence;
import com.hivemq.util.ObjectMemoryEstimation;
import com.hivemq.util.Strings;
import com.hivemq.util.ThreadPreConditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class ClientQueueMemoryLocalPersistence
implements ClientQueueLocalPersistence {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(ClientQueueMemoryLocalPersistence.class);
    private static final int NO_PACKET_ID = 0;
    @NotNull
    private final @NotNull Map<String, Messages> @NotNull [] buckets;
    @NotNull
    private final @NotNull Map<String, Messages> @NotNull [] sharedBuckets;
    @NotNull
    private final MessageDroppedService messageDroppedService;
    private final long qos0MemoryLimit;
    private final int qos0ClientMemoryLimit;
    private final int retainedMessageMax;
    @NotNull
    private final AtomicLong qos0MessagesMemory;
    @NotNull
    private final AtomicLong totalMemorySize;

    @Inject
    ClientQueueMemoryLocalPersistence(@NotNull MessageDroppedService messageDroppedService, @NotNull MetricRegistry metricRegistry) {
        int bucketCount = InternalConfigurations.PERSISTENCE_BUCKET_COUNT.get();
        this.buckets = new HashMap[bucketCount];
        this.sharedBuckets = new HashMap[bucketCount];
        for (int i = 0; i < bucketCount; ++i) {
            this.buckets[i] = new HashMap<String, Messages>();
            this.sharedBuckets[i] = new HashMap<String, Messages>();
        }
        this.messageDroppedService = messageDroppedService;
        this.qos0MemoryLimit = this.getQos0MemoryLimit();
        this.qos0ClientMemoryLimit = InternalConfigurations.QOS_0_MEMORY_LIMIT_PER_CLIENT_BYTES.get();
        this.retainedMessageMax = InternalConfigurations.RETAINED_MESSAGE_QUEUE_SIZE.get();
        this.qos0MessagesMemory = new AtomicLong();
        this.totalMemorySize = new AtomicLong();
        metricRegistry.register(HiveMQMetrics.QUEUED_MESSAGES_MEMORY_PERSISTENCE_TOTAL_SIZE.name(), (Metric)((Gauge)this.totalMemorySize::get));
    }

    private long getQos0MemoryLimit() {
        long maxHeap = Runtime.getRuntime().maxMemory();
        int hardLimitDivisor = InternalConfigurations.QOS_0_MEMORY_HARD_LIMIT_DIVISOR.get();
        long maxHardLimit = hardLimitDivisor < 1 ? maxHeap / 4L : maxHeap / (long)hardLimitDivisor;
        log.debug("{} allocated for qos 0 inflight messages", (Object)Strings.convertBytes(maxHardLimit));
        return maxHardLimit;
    }

    @Override
    @ExecuteInSingleWriter
    public void add(@NotNull String queueId, boolean shared, @NotNull PUBLISH publish, long max, @NotNull MqttConfigurationService.QueuedMessagesStrategy strategy, boolean retained, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        Preconditions.checkNotNull((Object)publish, (Object)"Publish must not be null");
        Preconditions.checkNotNull((Object)((Object)strategy), (Object)"Strategy must not be null");
        ThreadPreConditions.startsWith("single-writer");
        this.add(queueId, shared, List.of(publish), max, strategy, retained, bucketIndex);
    }

    @Override
    @ExecuteInSingleWriter
    public void add(@NotNull String queueId, boolean shared, @NotNull List<PUBLISH> publishes, long max, @NotNull MqttConfigurationService.QueuedMessagesStrategy strategy, boolean retained, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        Preconditions.checkNotNull(publishes, (Object)"Publishes must not be null");
        Preconditions.checkNotNull((Object)((Object)strategy), (Object)"Strategy must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = shared ? this.sharedBuckets[bucketIndex] : this.buckets[bucketIndex];
        Messages messages = bucket.computeIfAbsent(queueId, s -> new Messages());
        for (PUBLISH publish : publishes) {
            boolean discarded;
            PublishWithRetained publishWithRetained = new PublishWithRetained(publish, retained);
            if (publish.getQoS() == QoS.AT_MOST_ONCE) {
                this.addQos0Publish(queueId, shared, messages, publishWithRetained);
                continue;
            }
            int qos1And2QueueSize = messages.qos1Or2Messages.size() - messages.retainedQos1Or2Messages;
            if ((long)qos1And2QueueSize >= max && !retained) {
                if (strategy == MqttConfigurationService.QueuedMessagesStrategy.DISCARD) {
                    this.logMessageDropped(publish, shared, queueId);
                    continue;
                }
                discarded = this.discardOldest(queueId, shared, messages, false);
                if (!discarded) {
                    this.logMessageDropped(publish, shared, queueId);
                    continue;
                }
            } else if (messages.retainedQos1Or2Messages >= this.retainedMessageMax && retained) {
                if (strategy == MqttConfigurationService.QueuedMessagesStrategy.DISCARD) {
                    this.logMessageDropped(publish, shared, queueId);
                    continue;
                }
                discarded = this.discardOldest(queueId, shared, messages, true);
                if (!discarded) {
                    this.logMessageDropped(publish, shared, queueId);
                    continue;
                }
            } else if (retained) {
                ++messages.retainedQos1Or2Messages;
            }
            publishWithRetained.setPacketIdentifier(0);
            messages.qos1Or2Messages.add(publishWithRetained);
            this.increaseMessagesMemory(publishWithRetained.getEstimatedSize());
        }
    }

    private void addQos0Publish(@NotNull String queueId, boolean shared, @NotNull Messages messages, @NotNull PublishWithRetained publishWithRetained) {
        long currentQos0MessagesMemory = this.qos0MessagesMemory.get();
        if (currentQos0MessagesMemory >= this.qos0MemoryLimit) {
            if (shared) {
                this.messageDroppedService.qos0MemoryExceededShared(queueId, publishWithRetained.getTopic(), 0, currentQos0MessagesMemory, this.qos0MemoryLimit);
            } else {
                this.messageDroppedService.qos0MemoryExceeded(queueId, publishWithRetained.getTopic(), 0, currentQos0MessagesMemory, this.qos0MemoryLimit);
            }
            return;
        }
        if (!shared && messages.qos0Memory >= (long)this.qos0ClientMemoryLimit) {
            this.messageDroppedService.qos0MemoryExceeded(queueId, publishWithRetained.getTopic(), 0, messages.qos0Memory, this.qos0ClientMemoryLimit);
            return;
        }
        messages.qos0Messages.add(publishWithRetained);
        this.increaseQos0MessagesMemory(publishWithRetained.getEstimatedSize());
        this.increaseClientQos0MessagesMemory(messages, publishWithRetained.getEstimatedSize());
        this.increaseMessagesMemory(publishWithRetained.getEstimatedSize());
    }

    @Override
    @ExecuteInSingleWriter
    @NotNull
    public ImmutableList<PUBLISH> readNew(@NotNull String queueId, boolean shared, @NotNull ImmutableIntArray packetIds, long bytesLimit, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        Preconditions.checkNotNull((Object)packetIds, (Object)"Packet IDs must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = shared ? this.sharedBuckets[bucketIndex] : this.buckets[bucketIndex];
        Messages messages = bucket.get(queueId);
        if (messages == null) {
            return ImmutableList.of();
        }
        if (messages.qos1Or2Messages.isEmpty()) {
            return this.getQos0Publishes(messages, packetIds, bytesLimit);
        }
        int countLimit = packetIds.length();
        int messageCount = 0;
        int packetIdIndex = 0;
        int bytes = 0;
        ImmutableList.Builder publishes = ImmutableList.builder();
        Iterator iterator = messages.qos1Or2Messages.iterator();
        while (iterator.hasNext()) {
            PublishWithRetained publishWithRetained;
            MessageWithID messageWithID = (MessageWithID)iterator.next();
            if (!(messageWithID instanceof PublishWithRetained) || (publishWithRetained = (PublishWithRetained)messageWithID).getPacketIdentifier() != 0) continue;
            if (publishWithRetained.isExpired()) {
                iterator.remove();
                if (publishWithRetained.retained) {
                    --messages.retainedQos1Or2Messages;
                }
                this.increaseMessagesMemory(-publishWithRetained.getEstimatedSize());
            } else {
                int packetId = packetIds.get(packetIdIndex);
                publishWithRetained.setPacketIdentifier(packetId);
                publishes.add((Object)publishWithRetained);
                ++packetIdIndex;
                if (++messageCount == countLimit || (long)(bytes += publishWithRetained.getEstimatedSizeInMemory()) > bytesLimit) break;
            }
            PUBLISH qos0Publish = this.pollQos0Message(messages);
            if (qos0Publish != null && !qos0Publish.isExpired()) {
                publishes.add((Object)qos0Publish);
                ++messageCount;
                bytes += qos0Publish.getEstimatedSizeInMemory();
            }
            if (messageCount != countLimit && (long)bytes <= bytesLimit) continue;
            break;
        }
        return publishes.build();
    }

    @NotNull
    private ImmutableList<PUBLISH> getQos0Publishes(@NotNull Messages messages, @NotNull ImmutableIntArray packetIds, long bytesLimit) {
        PUBLISH qos0Publish;
        ImmutableList.Builder publishes = ImmutableList.builder();
        int qos0MessagesFound = 0;
        int qos0Bytes = 0;
        while (qos0MessagesFound < packetIds.length() && bytesLimit > (long)qos0Bytes && (qos0Publish = this.pollQos0Message(messages)) != null) {
            if (qos0Publish.isExpired()) continue;
            publishes.add((Object)qos0Publish);
            ++qos0MessagesFound;
            qos0Bytes += qos0Publish.getEstimatedSizeInMemory();
        }
        return publishes.build();
    }

    @Nullable
    private PUBLISH pollQos0Message(@NotNull Messages messages) {
        PublishWithRetained publishWithRetained = messages.qos0Messages.poll();
        if (publishWithRetained == null) {
            return null;
        }
        int estimatedSize = publishWithRetained.getEstimatedSize();
        this.increaseQos0MessagesMemory(-estimatedSize);
        this.increaseClientQos0MessagesMemory(messages, -estimatedSize);
        this.increaseMessagesMemory(-estimatedSize);
        return publishWithRetained;
    }

    @Override
    @ExecuteInSingleWriter
    @NotNull
    public ImmutableList<MessageWithID> readInflight(@NotNull String queueId, boolean shared, int batchSize, long bytesLimit, int bucketIndex) {
        MessageWithID messageWithID;
        Preconditions.checkNotNull((Object)queueId, (Object)"client id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = shared ? this.sharedBuckets[bucketIndex] : this.buckets[bucketIndex];
        Messages messages = bucket.get(queueId);
        if (messages == null) {
            return ImmutableList.of();
        }
        int messageCount = 0;
        int bytes = 0;
        ImmutableList.Builder publishes = ImmutableList.builder();
        Iterator iterator = messages.qos1Or2Messages.iterator();
        while (iterator.hasNext() && (messageWithID = (MessageWithID)iterator.next()).getPacketIdentifier() != 0) {
            publishes.add((Object)messageWithID);
            ++messageCount;
            if (messageWithID instanceof PublishWithRetained) {
                PublishWithRetained publishWithRetained = (PublishWithRetained)messageWithID;
                bytes += publishWithRetained.getEstimatedSizeInMemory();
                publishWithRetained.setDuplicateDelivery(true);
            }
            if (messageCount != batchSize && (long)bytes <= bytesLimit) continue;
            break;
        }
        return publishes.build();
    }

    @Override
    @ExecuteInSingleWriter
    @Nullable
    public String replace(@NotNull String queueId, @NotNull PUBREL pubrel, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"client id must not be null");
        Preconditions.checkNotNull((Object)pubrel, (Object)"pubrel must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = this.buckets[bucketIndex];
        Messages messages = bucket.get(queueId);
        if (messages == null) {
            return null;
        }
        boolean packetIdFound = false;
        String replacedId = null;
        boolean retained = false;
        int messageIndexInQueue = -1;
        for (MessageWithID messageWithID : messages.qos1Or2Messages) {
            ++messageIndexInQueue;
            int packetId = messageWithID.getPacketIdentifier();
            if (packetId == 0) break;
            if (packetId != pubrel.getPacketIdentifier()) continue;
            packetIdFound = true;
            if (messageWithID instanceof PublishWithRetained) {
                PublishWithRetained publish = (PublishWithRetained)messageWithID;
                retained = publish.retained;
                this.increaseMessagesMemory(-publish.getEstimatedSize());
                pubrel.setMessageExpiryInterval(publish.getMessageExpiryInterval());
                pubrel.setPublishTimestamp(publish.getTimestamp());
                replacedId = publish.getUniqueId();
                break;
            }
            if (!(messageWithID instanceof PubrelWithRetained)) break;
            PubrelWithRetained pubrelWithRetained = (PubrelWithRetained)messageWithID;
            pubrel.setMessageExpiryInterval(pubrelWithRetained.getMessageExpiryInterval());
            pubrel.setPublishTimestamp(pubrelWithRetained.getPublishTimestamp());
            retained = pubrelWithRetained.retained;
            break;
        }
        PubrelWithRetained pubrelWithRetained = new PubrelWithRetained(pubrel, retained);
        if (packetIdFound) {
            messages.qos1Or2Messages.set(messageIndexInQueue, pubrelWithRetained);
        } else {
            if (InternalConfigurations.EXPIRE_INFLIGHT_PUBRELS_ENABLED) {
                pubrelWithRetained.setMessageExpiryInterval(InternalConfigurations.MAXIMUM_INFLIGHT_PUBREL_EXPIRY);
                pubrelWithRetained.setPublishTimestamp(System.currentTimeMillis());
            }
            messages.qos1Or2Messages.addFirst(pubrelWithRetained);
        }
        this.increaseMessagesMemory(pubrelWithRetained.getEstimatedSize());
        return replacedId;
    }

    @Override
    @ExecuteInSingleWriter
    @Nullable
    public String remove(@NotNull String queueId, int packetId, int bucketIndex) {
        return this.remove(queueId, packetId, null, bucketIndex);
    }

    @Override
    @ExecuteInSingleWriter
    @Nullable
    public String remove(@NotNull String queueId, int packetId, @Nullable String uniqueId, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"client id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = this.buckets[bucketIndex];
        Messages messages = bucket.get(queueId);
        if (messages == null) {
            return null;
        }
        Iterator iterator = messages.qos1Or2Messages.iterator();
        while (iterator.hasNext()) {
            MessageWithID messageWithID = (MessageWithID)iterator.next();
            if (messageWithID.getPacketIdentifier() != packetId) continue;
            String removedId = null;
            if (messageWithID instanceof PublishWithRetained) {
                PublishWithRetained publish = (PublishWithRetained)messageWithID;
                if (uniqueId != null && !uniqueId.equals(publish.getUniqueId())) break;
                removedId = publish.getUniqueId();
            }
            if (this.isRetained(messageWithID)) {
                --messages.retainedQos1Or2Messages;
            }
            this.increaseMessagesMemory(-this.getMessageSize(messageWithID));
            iterator.remove();
            return removedId;
        }
        return null;
    }

    @Override
    @ExecuteInSingleWriter
    public int size(@NotNull String queueId, boolean shared, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = shared ? this.sharedBuckets[bucketIndex] : this.buckets[bucketIndex];
        Messages messages = bucket.get(queueId);
        return messages == null ? 0 : messages.qos1Or2Messages.size() + messages.qos0Messages.size();
    }

    @Override
    @ExecuteInSingleWriter
    public void clear(@NotNull String queueId, boolean shared, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue ID must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = shared ? this.sharedBuckets[bucketIndex] : this.buckets[bucketIndex];
        Messages messages = bucket.remove(queueId);
        if (messages == null) {
            return;
        }
        for (MessageWithID messageWithID : messages.qos1Or2Messages) {
            this.increaseMessagesMemory(-this.getMessageSize(messageWithID));
        }
        for (PublishWithRetained qos0Message : messages.qos0Messages) {
            int estimatedSize = qos0Message.getEstimatedSize();
            this.increaseQos0MessagesMemory(-estimatedSize);
            this.increaseMessagesMemory(-estimatedSize);
        }
    }

    @Override
    @ExecuteInSingleWriter
    public void removeAllQos0Messages(@NotNull String queueId, boolean shared, int bucketIndex) {
        Preconditions.checkNotNull((Object)queueId, (Object)"Queue id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = shared ? this.sharedBuckets[bucketIndex] : this.buckets[bucketIndex];
        Messages messages = bucket.get(queueId);
        if (messages == null) {
            return;
        }
        for (PublishWithRetained publishWithRetained : messages.qos0Messages) {
            this.increaseQos0MessagesMemory(-publishWithRetained.getEstimatedSize());
            this.increaseMessagesMemory(-publishWithRetained.getEstimatedSize());
        }
        messages.qos0Messages.clear();
        messages.qos0Memory = 0L;
    }

    @Override
    @ExecuteInSingleWriter
    @NotNull
    public ImmutableSet<String> cleanUp(int bucketIndex) {
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = this.buckets[bucketIndex];
        Map<String, Messages> sharedBucket = this.sharedBuckets[bucketIndex];
        bucket.forEach((queueId, messages) -> this.cleanExpiredMessages((Messages)messages));
        sharedBucket.forEach((queueId, messages) -> this.cleanExpiredMessages((Messages)messages));
        return ImmutableSet.copyOf(sharedBucket.keySet());
    }

    @Override
    @ExecuteInSingleWriter
    public void removeShared(@NotNull String sharedSubscription, @NotNull String uniqueId, int bucketIndex) {
        Preconditions.checkNotNull((Object)sharedSubscription, (Object)"Shared subscription must not be null");
        Preconditions.checkNotNull((Object)uniqueId, (Object)"Unique id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = this.sharedBuckets[bucketIndex];
        Messages messages = bucket.get(sharedSubscription);
        if (messages == null) {
            return;
        }
        Iterator iterator = messages.qos1Or2Messages.iterator();
        while (iterator.hasNext()) {
            PublishWithRetained publish;
            MessageWithID messageWithID = (MessageWithID)iterator.next();
            if (!(messageWithID instanceof PublishWithRetained) || !uniqueId.equals((publish = (PublishWithRetained)messageWithID).getUniqueId())) continue;
            if (publish.retained) {
                --messages.retainedQos1Or2Messages;
            }
            this.increaseMessagesMemory(-publish.getEstimatedSize());
            iterator.remove();
        }
    }

    @Override
    @ExecuteInSingleWriter
    public void removeInFlightMarker(@NotNull String sharedSubscription, @NotNull String uniqueId, int bucketIndex) {
        Preconditions.checkNotNull((Object)sharedSubscription, (Object)"Shared subscription must not be null");
        Preconditions.checkNotNull((Object)uniqueId, (Object)"Unique id must not be null");
        ThreadPreConditions.startsWith("single-writer");
        Map<String, Messages> bucket = this.sharedBuckets[bucketIndex];
        Messages messages = bucket.get(sharedSubscription);
        if (messages == null) {
            return;
        }
        for (MessageWithID messageWithID : messages.qos1Or2Messages) {
            PublishWithRetained publish;
            if (!(messageWithID instanceof PublishWithRetained) || !uniqueId.equals((publish = (PublishWithRetained)messageWithID).getUniqueId())) continue;
            publish.setPacketIdentifier(0);
            break;
        }
    }

    @Override
    @ExecuteInSingleWriter
    public void closeDB(int bucketIndex) {
        ThreadPreConditions.startsWith("single-writer");
        this.buckets[bucketIndex].clear();
        this.sharedBuckets[bucketIndex].clear();
        this.totalMemorySize.set(0L);
        this.qos0MessagesMemory.set(0L);
    }

    private int getMessageSize(@NotNull MessageWithID messageWithID) {
        if (messageWithID instanceof PublishWithRetained) {
            return ((PublishWithRetained)messageWithID).getEstimatedSize();
        }
        if (messageWithID instanceof PubrelWithRetained) {
            return ((PubrelWithRetained)messageWithID).getEstimatedSize();
        }
        return 0;
    }

    private boolean isRetained(@NotNull MessageWithID messageWithID) {
        if (messageWithID instanceof PublishWithRetained) {
            return ((PublishWithRetained)messageWithID).retained;
        }
        if (messageWithID instanceof PubrelWithRetained) {
            return ((PubrelWithRetained)messageWithID).retained;
        }
        return false;
    }

    private void logMessageDropped(@NotNull PUBLISH publish, boolean shared, @NotNull String queueId) {
        if (shared) {
            this.messageDroppedService.queueFullShared(queueId, publish.getTopic(), publish.getQoS().getQosNumber());
        } else {
            this.messageDroppedService.queueFull(queueId, publish.getTopic(), publish.getQoS().getQosNumber());
        }
    }

    private void increaseQos0MessagesMemory(int size) {
        if (size < 0) {
            this.qos0MessagesMemory.addAndGet(size - ObjectMemoryEstimation.linkedListNodeOverhead());
        } else {
            this.qos0MessagesMemory.addAndGet(size + ObjectMemoryEstimation.linkedListNodeOverhead());
        }
    }

    private void increaseMessagesMemory(int size) {
        if (size < 0) {
            this.totalMemorySize.addAndGet(size - ObjectMemoryEstimation.linkedListNodeOverhead());
        } else {
            this.totalMemorySize.addAndGet(size + ObjectMemoryEstimation.linkedListNodeOverhead());
        }
    }

    private void increaseClientQos0MessagesMemory(@NotNull Messages messages, int size) {
        messages.qos0Memory = size < 0 ? (messages.qos0Memory += (long)(size - ObjectMemoryEstimation.linkedListNodeOverhead())) : (messages.qos0Memory += (long)(size + ObjectMemoryEstimation.linkedListNodeOverhead()));
        if (messages.qos0Memory < 0L) {
            messages.qos0Memory = 0L;
        }
    }

    private boolean discardOldest(@NotNull String queueId, boolean shared, @NotNull Messages messages, boolean retainedOnly) {
        Iterator iterator = messages.qos1Or2Messages.iterator();
        while (iterator.hasNext()) {
            PublishWithRetained publish;
            MessageWithID messageWithID = (MessageWithID)iterator.next();
            if (!(messageWithID instanceof PublishWithRetained) || (publish = (PublishWithRetained)messageWithID).getPacketIdentifier() != 0 || retainedOnly != publish.retained) continue;
            this.logMessageDropped(publish, shared, queueId);
            iterator.remove();
            return true;
        }
        return false;
    }

    private void cleanExpiredMessages(@NotNull Messages messages) {
        Iterator iterator = messages.qos0Messages.iterator();
        while (iterator.hasNext()) {
            PublishWithRetained publishWithRetained = (PublishWithRetained)iterator.next();
            if (!publishWithRetained.isExpired()) continue;
            this.increaseQos0MessagesMemory(-publishWithRetained.getEstimatedSize());
            this.increaseClientQos0MessagesMemory(messages, -publishWithRetained.getEstimatedSize());
            this.increaseMessagesMemory(-publishWithRetained.getEstimatedSize());
            iterator.remove();
        }
        Iterator qos12iterator = messages.qos1Or2Messages.iterator();
        while (qos12iterator.hasNext()) {
            MessageWithID messageWithID = (MessageWithID)qos12iterator.next();
            if (messageWithID instanceof PubrelWithRetained) {
                PubrelWithRetained pubrel = (PubrelWithRetained)messageWithID;
                if (!InternalConfigurations.EXPIRE_INFLIGHT_PUBRELS_ENABLED || !pubrel.hasExpired(InternalConfigurations.MAXIMUM_INFLIGHT_PUBREL_EXPIRY)) continue;
                if (pubrel.retained) {
                    --messages.retainedQos1Or2Messages;
                }
                this.increaseMessagesMemory(-pubrel.getEstimatedSize());
                qos12iterator.remove();
                continue;
            }
            if (!(messageWithID instanceof PublishWithRetained)) continue;
            PublishWithRetained publish = (PublishWithRetained)messageWithID;
            boolean expireInflight = InternalConfigurations.EXPIRE_INFLIGHT_MESSAGES_ENABLED;
            boolean isInflight = publish.getQoS() == QoS.EXACTLY_ONCE && publish.getPacketIdentifier() > 0;
            boolean drop = publish.isExpired() && (!isInflight || expireInflight);
            if (!drop) continue;
            if (publish.retained) {
                --messages.retainedQos1Or2Messages;
            }
            this.increaseMessagesMemory(-publish.getEstimatedSize());
            qos12iterator.remove();
        }
    }

    private static class PubrelWithRetained
    extends PUBREL {
        private final boolean retained;

        private PubrelWithRetained(@NotNull PUBREL pubrel, boolean retained) {
            super(pubrel.getPacketIdentifier(), (Mqtt5PubRelReasonCode)pubrel.getReasonCode(), pubrel.getReasonString(), pubrel.getUserProperties(), pubrel.getPublishTimestamp(), pubrel.getMessageExpiryInterval());
            this.retained = retained;
        }

        private int getEstimatedSize() {
            return this.getEstimatedSizeInMemory() + ObjectMemoryEstimation.objectShellSize() + ObjectMemoryEstimation.booleanSize();
        }
    }

    @VisibleForTesting
    static class PublishWithRetained
    extends PUBLISH {
        private final boolean retained;

        PublishWithRetained(@NotNull PUBLISH publish, boolean retained) {
            super(publish);
            this.retained = retained;
        }

        int getEstimatedSize() {
            return this.getEstimatedSizeInMemory() + ObjectMemoryEstimation.objectShellSize() + ObjectMemoryEstimation.booleanSize();
        }
    }

    private static class Messages {
        @NotNull
        final LinkedList<MessageWithID> qos1Or2Messages = new LinkedList();
        @NotNull
        final LinkedList<PublishWithRetained> qos0Messages = new LinkedList();
        int retainedQos1Or2Messages = 0;
        long qos0Memory = 0L;

        private Messages() {
        }
    }
}

