/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus;

import com.google.common.collect.ImmutableSet;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class PublishTopicTree {
    private final Node root = new Node();

    public void add(@NotNull String topic) {
        ArrayList<String> subTopics = new ArrayList<String>(Arrays.asList(StringUtils.splitPreserveAllTokens((String)topic, (char)'/')));
        this.root.add(subTopics);
    }

    @NotNull
    public Set<String> get(@NotNull String topic) {
        ArrayList<String> subTopics = new ArrayList<String>(Arrays.asList(StringUtils.splitPreserveAllTokens((String)topic, (char)'/')));
        return this.root.get(subTopics, null, false);
    }

    public void remove(@NotNull String topic) {
        ArrayList<String> subTopics = new ArrayList<String>(Arrays.asList(StringUtils.splitPreserveAllTokens((String)topic, (char)'/')));
        this.root.remove(subTopics);
    }

    private static class Node {
        @Nullable
        Node child = null;
        @Nullable
        String childSubTopic = null;
        @Nullable
        Map<String, Node> childNodes = null;
        boolean directMatch = false;

        private Node() {
        }

        public void add(@NotNull ArrayList<String> subTopics) {
            Node nextChild;
            String currentSubTopic = subTopics.get(0);
            if (this.child != null && !currentSubTopic.equals(this.childSubTopic)) {
                this.childNodes = new HashMap<String, Node>(1);
                this.childNodes.put(this.childSubTopic, this.child);
                this.child = null;
                this.childSubTopic = null;
            }
            if (this.childNodes != null) {
                nextChild = this.childNodes.get(currentSubTopic);
                if (nextChild == null) {
                    nextChild = new Node();
                    this.childNodes.put(currentSubTopic, nextChild);
                }
            } else if (this.child == null) {
                this.child = new Node();
                this.childSubTopic = currentSubTopic;
                nextChild = this.child;
            } else {
                nextChild = this.child;
            }
            subTopics.remove(0);
            if (!subTopics.isEmpty()) {
                nextChild.add(subTopics);
            } else {
                nextChild.directMatch();
            }
        }

        private void directMatch() {
            this.directMatch = true;
        }

        public boolean remove(@NotNull ArrayList<String> subTopics) {
            if (subTopics.isEmpty()) {
                if (!this.directMatch) {
                    return false;
                }
                this.directMatch = false;
                return this.childNodes == null && this.child == null;
            }
            if (this.childNodes == null && this.child == null) {
                return false;
            }
            String currentSubTopic = subTopics.get(0);
            if (this.child != null) {
                if (this.childSubTopic.equals(currentSubTopic)) {
                    ArrayList<String> nextSubTopics = new ArrayList<String>(subTopics);
                    nextSubTopics.remove(0);
                    boolean removed = this.child.remove(nextSubTopics);
                    if (removed && !this.child.directMatch) {
                        this.child = null;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            Node node = this.childNodes.get(currentSubTopic);
            if (node == null) {
                return false;
            }
            ArrayList<String> nextSubTopics = new ArrayList<String>(subTopics);
            nextSubTopics.remove(0);
            boolean removed = node.remove(nextSubTopics);
            if (removed && !node.directMatch) {
                this.childNodes.remove(currentSubTopic);
                if (this.childNodes.size() == 1) {
                    Map.Entry<String, Node> entry = this.childNodes.entrySet().iterator().next();
                    this.child = entry.getValue();
                    this.childSubTopic = entry.getKey();
                    this.childNodes = null;
                }
            }
            return false;
        }

        @NotNull
        public Set<String> get(@NotNull ArrayList<String> subTopics, @Nullable String currentTopic, boolean getAll) {
            if (this.childNodes == null && this.child == null) {
                if (currentTopic == null) {
                    return ImmutableSet.of();
                }
                if (subTopics.isEmpty() || getAll) {
                    return ImmutableSet.of((Object)currentTopic);
                }
                String currentSubTopic = subTopics.get(0);
                if (currentSubTopic.equals("#")) {
                    return ImmutableSet.of((Object)currentTopic);
                }
                return ImmutableSet.of();
            }
            HashSet<String> result = new HashSet<String>();
            if (subTopics.isEmpty()) {
                if (this.directMatch) {
                    result.add(currentTopic);
                }
                return result;
            }
            String currentSubTopic = subTopics.get(0);
            if ((getAll || currentSubTopic.equals("#")) && this.directMatch) {
                result.add(currentTopic);
            }
            if (currentSubTopic.equals("+") || currentSubTopic.equals("#")) {
                ArrayList<String> nextSubTopics = new ArrayList<String>(subTopics);
                if (!currentSubTopic.equals("#")) {
                    nextSubTopics.remove(0);
                }
                if (this.childNodes != null) {
                    for (Map.Entry<String, Node> entry : this.childNodes.entrySet()) {
                        if (currentTopic == null) {
                            result.addAll(entry.getValue().get(nextSubTopics, entry.getKey(), currentSubTopic.equals("#")));
                            continue;
                        }
                        result.addAll(entry.getValue().get(nextSubTopics, currentTopic + "/" + entry.getKey(), currentSubTopic.equals("#")));
                    }
                } else if (this.child != null) {
                    if (currentTopic == null) {
                        result.addAll(this.child.get(nextSubTopics, this.childSubTopic, currentSubTopic.equals("#")));
                    } else {
                        result.addAll(this.child.get(nextSubTopics, currentTopic + "/" + this.childSubTopic, currentSubTopic.equals("#")));
                    }
                }
            } else {
                Node nextChild;
                ArrayList<String> nextSubTopics = new ArrayList<String>(subTopics);
                nextSubTopics.remove(0);
                if (this.childNodes != null) {
                    nextChild = this.childNodes.get(currentSubTopic);
                    if (nextChild == null) {
                        return result;
                    }
                } else {
                    if (this.child == null || !this.childSubTopic.equals(currentSubTopic)) {
                        return result;
                    }
                    nextChild = this.child;
                }
                if (currentTopic == null) {
                    result.addAll(nextChild.get(nextSubTopics, currentSubTopic, false));
                } else {
                    result.addAll(nextChild.get(nextSubTopics, currentTopic + "/" + currentSubTopic, false));
                }
            }
            return result;
        }
    }
}

