/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.persistence.local.xodus;

import com.google.common.base.Preconditions;
import com.google.common.base.Utf8;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.util.Bytes;
import java.nio.charset.StandardCharsets;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;

public class XodusUtils {
    private XodusUtils() {
    }

    @NotNull
    public static ByteIterable stringToByteIterable(@NotNull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"String must not be null");
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return new ArrayByteIterable(bytes);
    }

    @NotNull
    public static ByteIterable bytesToByteIterable(@NotNull byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes must not be null");
        return new ArrayByteIterable(bytes);
    }

    @NotNull
    public static String byteIterableToString(@NotNull ByteIterable byteIterable) {
        Preconditions.checkNotNull((Object)byteIterable, (Object)"ByteIterable must not be null");
        return new String(byteIterable.getBytesUnsafe(), 0, byteIterable.getLength(), StandardCharsets.UTF_8);
    }

    @NotNull
    public static byte[] byteIterableToBytes(@NotNull ByteIterable byteIterable) {
        Preconditions.checkNotNull((Object)byteIterable, (Object)"ByteIterable must not be null");
        byte[] unsafeBytes = byteIterable.getBytesUnsafe();
        if (unsafeBytes.length == byteIterable.getLength()) {
            return unsafeBytes;
        }
        byte[] bytes = new byte[byteIterable.getLength()];
        System.arraycopy(unsafeBytes, 0, bytes, 0, bytes.length);
        return bytes;
    }

    public static int serializeByte(byte b, @NotNull byte[] serialized, int offset) {
        serialized[offset] = b;
        return offset + 1;
    }

    public static int serializeShort(int s, @NotNull byte[] serialized, int offset) {
        Bytes.copyUnsignedShortToByteArray(s, serialized, offset);
        return offset + 2;
    }

    public static int serializeLong(long l, @NotNull byte[] serialized, int offset) {
        Bytes.copyLongToByteArray(l, serialized, offset);
        return offset + 8;
    }

    public static int shortLengthStringSize(@Nullable String string) {
        return 2 + (string == null ? 0 : Utf8.encodedLength((CharSequence)string));
    }

    public static int shortLengthArraySize(@Nullable byte[] bytes) {
        return 2 + (bytes == null ? 0 : bytes.length);
    }

    public static int serializeShortLengthString(@Nullable String string, @NotNull byte[] serialized, int offset) {
        return XodusUtils.serializeShortLengthArray(string == null ? null : string.getBytes(StandardCharsets.UTF_8), serialized, offset);
    }

    public static int serializeShortLengthArray(@Nullable byte[] bytes, @NotNull byte[] serialized, int offset) {
        int length = bytes == null ? 0 : bytes.length;
        Bytes.copyUnsignedShortToByteArray(length, serialized, offset);
        offset += 2;
        if (length == 0) {
            return offset;
        }
        System.arraycopy(bytes, 0, serialized, offset, length);
        return offset + length;
    }
}

