/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.security.ssl;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.ReferenceCountUtil;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslSniHandler
extends SniHandler {
    private static final Logger log = LoggerFactory.getLogger(SslSniHandler.class);
    @NotNull
    private final SslHandler sslHandler;

    public SslSniHandler(@NotNull SslHandler sslHandler, @NotNull SslContext sslContext) {
        super((input, promise) -> {
            promise.setSuccess((Object)sslContext);
            return promise;
        });
        this.sslHandler = sslHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceHandler(@NotNull ChannelHandlerContext ctx, @Nullable String hostname, @NotNull SslContext sslContext) throws Exception {
        if (hostname != null) {
            ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(ctx.channel());
            clientConnectionContext.setAuthSniHostname(hostname);
            if (log.isTraceEnabled()) {
                log.trace("Client with IP '{}' sent SNI hostname '{}'", (Object)clientConnectionContext.getChannelIP().orElse("UNKNOWN"), (Object)hostname);
            }
        }
        SslHandler sslHandlerInstance = null;
        try {
            sslHandlerInstance = this.sslHandler;
            ctx.pipeline().replace((ChannelHandler)this, "ssl_handler", (ChannelHandler)sslHandlerInstance);
            sslHandlerInstance = null;
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            if (sslHandlerInstance != null) {
                ReferenceCountUtil.safeRelease((Object)sslHandlerInstance.engine());
            }
        }
    }
}

