/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.util.Utf8Utils;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class Strings {
    private Strings() {
    }

    public static String getPrefixedString(ByteBuf buf) {
        Preconditions.checkNotNull((Object)buf);
        if (buf.readableBytes() < 2) {
            return null;
        }
        int utf8StringLength = buf.readUnsignedShort();
        if (buf.readableBytes() < utf8StringLength) {
            return null;
        }
        return Strings.getPrefixedString(buf, utf8StringLength);
    }

    public static String getPrefixedString(ByteBuf buf, int utf8StringLength) {
        Preconditions.checkNotNull((Object)buf);
        String string = buf.toString(buf.readerIndex(), utf8StringLength, StandardCharsets.UTF_8);
        buf.skipBytes(utf8StringLength);
        return string;
    }

    public static String getValidatedPrefixedString(@NotNull ByteBuf buf, int utf8StringLength, boolean validateShouldNotCharacters) {
        Preconditions.checkNotNull((Object)buf);
        if (buf.readableBytes() < utf8StringLength) {
            return null;
        }
        byte[] bytes = new byte[utf8StringLength];
        buf.getBytes(buf.readerIndex(), bytes);
        if (Utf8Utils.containsMustNotCharacters(bytes)) {
            return null;
        }
        if (validateShouldNotCharacters && Utf8Utils.hasControlOrNonCharacter(bytes)) {
            return null;
        }
        buf.skipBytes(utf8StringLength);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static ByteBuf createPrefixedBytesFromString(String string, ByteBuf buffer) {
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)buffer);
        if (Utf8Utils.stringIsOneByteCharsOnly(string)) {
            buffer.writeShort(string.length());
            for (int i = 0; i < string.length(); ++i) {
                buffer.writeByte((int)string.charAt(i));
            }
        } else {
            byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
            buffer.writeShort(bytes.length);
            buffer.writeBytes(bytes);
        }
        return buffer;
    }

    @VisibleForTesting
    public static String convertBytes(long bytes) {
        long kbDivisor = 1024L;
        long mbDivisor = 0x100000L;
        long gbDivisor = 0x40000000L;
        long tbDivisor = 0x10000000000L;
        if (bytes <= 1024L) {
            return bytes + " B";
        }
        if (bytes <= 0x100000L) {
            double kb = (double)bytes / 1024.0;
            return String.format(Locale.US, "%.2f", kb) + " KB";
        }
        if (bytes <= 0x40000000L) {
            double mb = (double)bytes / 1048576.0;
            return String.format(Locale.US, "%.2f", mb) + " MB";
        }
        if (bytes <= 0x10000000000L) {
            double gb = (double)bytes / 1.073741824E9;
            return String.format(Locale.US, "%.2f", gb) + " GB";
        }
        double tb = (double)bytes / 1.099511627776E12;
        return String.format(Locale.US, "%.2f", tb) + " TB";
    }
}

