/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.util;

import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.persistence.clientsession.SharedSubscriptionService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Topics {
    private static final char[] SHARED_SUBSCRIPTION_CHAR_ARRAY = "$share".toCharArray();
    private static final int SHARED_SUBSCRIPTION_LENGTH = SHARED_SUBSCRIPTION_CHAR_ARRAY.length;
    private static final char SHARED_SUBSCRIPTION_DELIMITER = '/';
    private static final int GROUP_INDEX = 2;
    private static final int TOPIC_INDEX = 3;
    private static final char MULTI_LEVEL_WILDCARD = '#';
    private static final char SINGLE_LEVEL_WILDCARD = '+';
    private static final Pattern SHARED_SUBSCRIPTION_PATTERN = Pattern.compile("\\$share(/(.*?)/(.*))");

    public static boolean isSharedSubscriptionTopic(@NotNull String topic) {
        if (!topic.startsWith("$share/")) {
            return false;
        }
        Matcher matcher = SHARED_SUBSCRIPTION_PATTERN.matcher(topic);
        return matcher.matches();
    }

    public static boolean isValidTopicToPublish(@NotNull String topic) {
        if (topic.isEmpty()) {
            return false;
        }
        if (topic.contains("\u0000")) {
            return false;
        }
        return topic.indexOf("#") <= -1 && topic.indexOf("+") <= -1;
    }

    public static boolean isValidToSubscribe(@NotNull String topic) {
        if (topic.isEmpty()) {
            return false;
        }
        if (topic.contains("\u0000")) {
            return false;
        }
        char lastChar = topic.charAt(0);
        int sharedSubscriptionDelimiterCharCount = 0;
        int length = topic.length();
        boolean isSharedSubscription = false;
        int sharedCounter = lastChar == SHARED_SUBSCRIPTION_CHAR_ARRAY[0] ? 1 : -1;
        for (int i = 1; i < length; ++i) {
            char currentChar = topic.charAt(i);
            if (i < SHARED_SUBSCRIPTION_LENGTH && currentChar == SHARED_SUBSCRIPTION_CHAR_ARRAY[i]) {
                ++sharedCounter;
            }
            if (i == SHARED_SUBSCRIPTION_LENGTH && sharedCounter == SHARED_SUBSCRIPTION_LENGTH && currentChar == '/') {
                isSharedSubscription = true;
            }
            if (isSharedSubscription && sharedSubscriptionDelimiterCharCount == 1) {
                if (currentChar == '+' || currentChar == '#') {
                    return false;
                }
                if (lastChar == '/' && currentChar == '/') {
                    return false;
                }
            }
            if (isSharedSubscription && currentChar == '/') {
                ++sharedSubscriptionDelimiterCharCount;
            }
            if (i == length - 1 && currentChar == '#' && lastChar == '/') {
                return true;
            }
            if (lastChar == '#' || currentChar == '#' && i == length - 1) {
                return false;
            }
            if (!(currentChar != '+' || lastChar == '/' || sharedSubscriptionDelimiterCharCount == 2 && isSharedSubscription && lastChar == '/')) {
                return false;
            }
            if (lastChar == '+' && currentChar != '/') {
                return false;
            }
            lastChar = currentChar;
        }
        return !isSharedSubscription || sharedSubscriptionDelimiterCharCount >= 2;
    }

    public static boolean isDollarTopic(@NotNull String topic) {
        return topic.startsWith("$");
    }

    public static boolean containsWildcard(String topic) {
        return topic.indexOf(35) != -1 || topic.indexOf(43) != -1;
    }

    public static SharedSubscriptionService.SharedSubscription checkForSharedSubscription(@NotNull String topic) {
        Matcher matcher = SHARED_SUBSCRIPTION_PATTERN.matcher(topic);
        if (matcher.matches()) {
            String shareGroup = matcher.group(2);
            String subscriptionTopic = matcher.group(3);
            return new SharedSubscriptionService.SharedSubscription(subscriptionTopic, shareGroup);
        }
        return null;
    }
}

