/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sql.query;

import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.basyx.components.tools.propertyfile.opdef.OperationDefinition;
import org.eclipse.basyx.components.tools.propertyfile.opdef.Parameter;
import org.eclipse.basyx.components.tools.propertyfile.opdef.ResultFilter;
import org.eclipse.basyx.tools.sql.driver.ISQLDriver;
import org.eclipse.basyx.tools.sql.query.DynamicSQLRunner;

public class DynamicSQLQuery
extends DynamicSQLRunner
implements Supplier<Object> {
    protected String sqlQueryString = null;
    protected String resultFilterString = null;

    public DynamicSQLQuery(ISQLDriver driver, String query, String sqlResultFilter) {
        super(driver);
        this.sqlQueryString = query;
        this.resultFilterString = sqlResultFilter;
    }

    public DynamicSQLQuery(String path, String user, String pass, String qryPfx, String qDrvCls, String query, String sqlResultFilter) {
        super(path, user, pass, qryPfx, qDrvCls);
        this.sqlQueryString = query;
        this.resultFilterString = sqlResultFilter;
    }

    @Override
    public Object get() {
        ResultSet sqlResult = this.sqlDriver.sqlQuery(this.sqlQueryString);
        return this.processResult(sqlResult);
    }

    public ResultSet getRaw() {
        return this.sqlDriver.sqlQuery(this.sqlQueryString);
    }

    public Object get(Map<String, Object> param) {
        String sqlQuery = OperationDefinition.getSQLString(this.sqlQueryString, param);
        ResultSet sqlResult = this.sqlDriver.sqlQuery(sqlQuery);
        return this.processResult(sqlResult);
    }

    public ResultSet getRaw(Map<String, Object> param) {
        String sqlQuery = OperationDefinition.getSQLString(this.sqlQueryString, param);
        return this.sqlDriver.sqlQuery(sqlQuery);
    }

    protected Object processResult(ResultSet sqlResult) {
        Collection<Parameter> parameter = OperationDefinition.getParameter(this.resultFilterString);
        try {
            Object[] callParameterInner = new Object[parameter.size()];
            int i = 0;
            for (String column : this.getColumnNames(parameter)) {
                callParameterInner[i++] = column;
            }
            Object[] callParameter = new Object[]{sqlResult, callParameterInner};
            Object result = ResultFilter.class.getMethod(OperationDefinition.getOperation(this.resultFilterString), this.getMethodParameter(parameter)).invoke(null, callParameter);
            sqlResult.close();
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

