/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util.keyrange;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Comparator;

public class KeyRange {
    public static final byte[] ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    Comparator<byte[]> comparator;
    DatabaseEntry beginKey;
    DatabaseEntry endKey;
    boolean singleKey;
    boolean beginInclusive;
    boolean endInclusive;

    public KeyRange(Comparator<byte[]> comparator) {
        this.comparator = comparator;
    }

    public KeyRange subRange(DatabaseEntry key) throws KeyRangeException {
        if (!this.check(key)) {
            throw new KeyRangeException("singleKey out of range");
        }
        KeyRange range = new KeyRange(this.comparator);
        range.beginKey = key;
        range.endKey = key;
        range.beginInclusive = true;
        range.endInclusive = true;
        range.singleKey = true;
        return range;
    }

    public KeyRange subRange(DatabaseEntry beginKey, boolean beginInclusive, DatabaseEntry endKey, boolean endInclusive) throws KeyRangeException {
        if (beginKey == null) {
            beginKey = this.beginKey;
            beginInclusive = this.beginInclusive;
        } else if (!this.check(beginKey, beginInclusive)) {
            throw new KeyRangeException("beginKey out of range");
        }
        if (endKey == null) {
            endKey = this.endKey;
            endInclusive = this.endInclusive;
        } else if (!this.check(endKey, endInclusive)) {
            throw new KeyRangeException("endKey out of range");
        }
        KeyRange range = new KeyRange(this.comparator);
        range.beginKey = beginKey;
        range.endKey = endKey;
        range.beginInclusive = beginInclusive;
        range.endInclusive = endInclusive;
        return range;
    }

    public final boolean isSingleKey() {
        return this.singleKey;
    }

    public final DatabaseEntry getSingleKey() {
        return this.singleKey ? this.beginKey : null;
    }

    public final boolean hasBound() {
        return this.endKey != null || this.beginKey != null;
    }

    public String toString() {
        return "[KeyRange " + this.beginKey + ' ' + this.beginInclusive + this.endKey + ' ' + this.endInclusive + (this.singleKey ? " single" : "");
    }

    public boolean check(DatabaseEntry key) {
        if (this.singleKey) {
            return this.compare(key, this.beginKey) == 0;
        }
        return this.checkBegin(key, true) && this.checkEnd(key, true);
    }

    public boolean check(DatabaseEntry key, boolean inclusive) {
        if (this.singleKey) {
            return this.compare(key, this.beginKey) == 0;
        }
        return this.checkBegin(key, inclusive) && this.checkEnd(key, inclusive);
    }

    public boolean checkBegin(DatabaseEntry key, boolean inclusive) {
        if (this.beginKey == null) {
            return true;
        }
        if (!this.beginInclusive && inclusive) {
            return this.compare(key, this.beginKey) > 0;
        }
        return this.compare(key, this.beginKey) >= 0;
    }

    public boolean checkEnd(DatabaseEntry key, boolean inclusive) {
        if (this.endKey == null) {
            return true;
        }
        if (!this.endInclusive && inclusive) {
            return this.compare(key, this.endKey) < 0;
        }
        return this.compare(key, this.endKey) <= 0;
    }

    public int compare(DatabaseEntry key1, DatabaseEntry key2) {
        if (this.comparator != null) {
            return this.comparator.compare(KeyRange.getByteArray(key1), KeyRange.getByteArray(key2));
        }
        return KeyRange.compareBytes(key1.getData(), key1.getOffset(), key1.getSize(), key2.getData(), key2.getOffset(), key2.getSize());
    }

    public static byte[] copyBytes(byte[] bytes) {
        byte[] a = new byte[bytes.length];
        System.arraycopy(bytes, 0, a, 0, a.length);
        return a;
    }

    public static int compareBytes(byte[] data1, int offset1, int size1, byte[] data2, int offset2, int size2) {
        for (int i = 0; i < size1 && i < size2; ++i) {
            int b1 = 0xFF & data1[offset1 + i];
            int b2 = 0xFF & data2[offset2 + i];
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        if (size1 < size2) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        return 0;
    }

    public static boolean equalBytes(byte[] data1, int offset1, int size1, byte[] data2, int offset2, int size2) {
        if (size1 != size2) {
            return false;
        }
        for (int i = 0; i < size1; ++i) {
            if (data1[i + offset1] == data2[i + offset2]) continue;
            return false;
        }
        return true;
    }

    public static DatabaseEntry copy(DatabaseEntry from) {
        return new DatabaseEntry(KeyRange.getByteArray(from));
    }

    public static void copy(DatabaseEntry from, DatabaseEntry to) {
        to.setData(KeyRange.getByteArray(from));
        to.setOffset(0);
    }

    public static byte[] getByteArray(DatabaseEntry entry) {
        return KeyRange.getByteArrayInternal(entry, Integer.MAX_VALUE);
    }

    public static byte[] getByteArray(DatabaseEntry entry, int maxBytes) {
        return KeyRange.getByteArrayInternal(entry, maxBytes);
    }

    private static byte[] getByteArrayInternal(DatabaseEntry entry, int maxBytes) {
        byte[] data;
        byte[] bytes = entry.getData();
        if (bytes == null) {
            return null;
        }
        int size = Math.min(entry.getSize(), maxBytes);
        if (size == 0) {
            data = ZERO_LENGTH_BYTE_ARRAY;
        } else {
            data = new byte[size];
            System.arraycopy(bytes, entry.getOffset(), data, 0, size);
        }
        return data;
    }

    public static boolean equalBytes(DatabaseEntry e1, DatabaseEntry e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        byte[] d1 = e1.getData();
        byte[] d2 = e2.getData();
        int s1 = e1.getSize();
        int s2 = e2.getSize();
        int o1 = e1.getOffset();
        int o2 = e2.getOffset();
        if (d1 == null && d2 == null) {
            return true;
        }
        if (d1 == null || d2 == null) {
            return false;
        }
        if (s1 != s2) {
            return false;
        }
        for (int i = 0; i < s1; ++i) {
            if (d1[o1 + i] == d2[o2 + i]) continue;
            return false;
        }
        return true;
    }

    public static String toString(DatabaseEntry dbt) {
        int len = dbt.getOffset() + dbt.getSize();
        StringBuilder buf = new StringBuilder(len * 2);
        byte[] data = dbt.getData();
        for (int i = dbt.getOffset(); i < len; ++i) {
            String num = Integer.toHexString(data[i]);
            if (num.length() < 2) {
                buf.append('0');
            }
            buf.append(num);
        }
        return buf.toString();
    }
}

