/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.je.Database;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import java.util.List;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseCallable;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseTemplate;
import org.apache.qpid.server.store.berkeleydb.upgrade.StoreUpgrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStoreUpgrade
implements StoreUpgrade {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStoreUpgrade.class);

    protected void reportFinished(Environment environment, int version) {
        LOGGER.info("Completed upgrade to version " + version);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Upgraded:");
            this.reportDatabaseRowCount(environment);
        }
    }

    private void reportDatabaseRowCount(Environment environment) {
        List databases = environment.getDatabaseNames();
        for (String database : databases) {
            LOGGER.debug("    " + this.getRowCount(database, environment) + " rows in " + database);
        }
    }

    protected void reportStarting(Environment environment, int version) {
        LOGGER.info("Starting store upgrade from version " + version);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Upgrading:");
            this.reportDatabaseRowCount(environment);
        }
    }

    private long getRowCount(String databaseName, Environment environment) {
        DatabaseCallable<Long> operation = new DatabaseCallable<Long>(){

            @Override
            public Long call(Database sourceDatabase, Database targetDatabase, Transaction transaction) {
                return sourceDatabase.count();
            }
        };
        return new DatabaseTemplate(environment, databaseName, null).call(operation);
    }
}

