/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectAttribute;
import org.apache.qpid.server.model.ConfiguredObjectTypeRegistry;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.handler.ConfiguredObjectRecordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementModeStoreHandler
implements DurableConfigurationStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagementModeStoreHandler.class);
    private static final String MANAGEMENT_MODE_PORT_PREFIX = "MANAGEMENT-MODE-PORT-";
    private static final String PORT_TYPE = Port.class.getSimpleName();
    private static final String VIRTUAL_HOST_NODE_TYPE = VirtualHostNode.class.getSimpleName();
    private static final String ATTRIBUTE_DESIRED_STATE = "desiredState";
    private static final Object MANAGEMENT_MODE_AUTH_PROVIDER = "mm-auth";
    private StoreState _state = StoreState.CLOSED;
    private final Object _lock = new Object();
    private final DurableConfigurationStore _store;
    private Map<UUID, ConfiguredObjectRecord> _cliEntries;
    private Map<UUID, Object> _quiescedEntriesOriginalState;
    private final SystemConfig<?> _systemConfig;
    private ConfiguredObject<?> _parent;
    private HashMap<UUID, ConfiguredObjectRecord> _records;

    public ManagementModeStoreHandler(DurableConfigurationStore store, SystemConfig<?> systemConfig) {
        this._systemConfig = systemConfig;
        this._store = store;
    }

    @Override
    public void init(ConfiguredObject<?> parent) throws StoreException {
        this.changeState(StoreState.CLOSED, StoreState.CONFIGURED);
        this._parent = parent;
        this._store.init(parent);
    }

    @Override
    public void upgradeStoreStructure() throws StoreException {
        this._store.upgradeStoreStructure();
    }

    @Override
    public boolean openConfigurationStore(ConfiguredObjectRecordHandler recoveryHandler, ConfiguredObjectRecord ... initialRecords) throws StoreException {
        this.changeState(StoreState.CONFIGURED, StoreState.OPEN);
        this._records = new HashMap();
        UnderlyingStoreRecoveringObjectRecordHandler underlyingHandler = new UnderlyingStoreRecoveringObjectRecordHandler();
        boolean isNew = this._store.openConfigurationStore(underlyingHandler, initialRecords);
        this._quiescedEntriesOriginalState = this.quiesceEntries(this._systemConfig, underlyingHandler.getRecoveredRecords());
        this.recoverRecords(underlyingHandler.getRecoveredRecords());
        this._cliEntries = this.createPortsFromCommandLineOptions(this._systemConfig);
        for (ConfiguredObjectRecord entry : this._cliEntries.values()) {
            this._records.put(entry.getId(), entry);
        }
        for (ConfiguredObjectRecord record : this._records.values()) {
            recoveryHandler.handle(record);
        }
        return isNew;
    }

    @Override
    public void reload(ConfiguredObjectRecordHandler handle) throws StoreException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ConfiguredObjectRecord object) {
        this.assertState(StoreState.OPEN);
        DurableConfigurationStore durableConfigurationStore = this._store;
        synchronized (durableConfigurationStore) {
            this._store.create(object);
        }
        this._records.put(object.getId(), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(boolean createIfNecessary, ConfiguredObjectRecord ... records) throws StoreException {
        this.assertState(StoreState.OPEN);
        ConfiguredObjectRecord[] configuredObjectRecordArray = this._store;
        synchronized (this._store) {
            ArrayList<ConfiguredObjectRecord> actualUpdates = new ArrayList<ConfiguredObjectRecord>();
            for (ConfiguredObjectRecord record : records) {
                if (this._cliEntries.containsKey(record.getId())) {
                    throw new IllegalConfigurationException("Cannot save configuration provided as command line argument:" + record);
                }
                if (this._quiescedEntriesOriginalState.containsKey(record.getId())) {
                    record = this.createEntryWithState(record, this._quiescedEntriesOriginalState.get(record.getId()));
                }
                actualUpdates.add(record);
            }
            this._store.update(createIfNecessary, actualUpdates.toArray(new ConfiguredObjectRecord[actualUpdates.size()]));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (ConfiguredObjectRecord record : records) {
                this._records.put(record.getId(), record);
            }
            return;
        }
    }

    @Override
    public void closeConfigurationStore() throws StoreException {
        this.changeState(StoreState.OPEN, StoreState.CLOSED);
        this._store.closeConfigurationStore();
    }

    @Override
    public void onDelete(ConfiguredObject<?> parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized UUID[] remove(ConfiguredObjectRecord ... records) {
        this.assertState(StoreState.OPEN);
        DurableConfigurationStore durableConfigurationStore = this._store;
        synchronized (durableConfigurationStore) {
            UUID[] idsToRemove = new UUID[records.length];
            for (int i = 0; i < records.length; ++i) {
                idsToRemove[i] = records[i].getId();
            }
            for (UUID id : idsToRemove) {
                if (!this._cliEntries.containsKey(id)) continue;
                throw new IllegalConfigurationException("Cannot change configuration for command line entry:" + this._cliEntries.get(id));
            }
            UUID[] result = this._store.remove(records);
            for (UUID id : idsToRemove) {
                if (!this._quiescedEntriesOriginalState.containsKey(id)) continue;
                this._quiescedEntriesOriginalState.remove(id);
            }
            for (ConfiguredObjectRecord record : records) {
                this._records.remove(record.getId());
            }
            return result;
        }
    }

    private Map<UUID, ConfiguredObjectRecord> createPortsFromCommandLineOptions(SystemConfig<?> options) {
        int managementModeHttpPortOverride = options.getManagementModeHttpPortOverride();
        if (managementModeHttpPortOverride < 0) {
            throw new IllegalConfigurationException("Invalid http port is specified: " + managementModeHttpPortOverride);
        }
        HashMap<UUID, ConfiguredObjectRecord> cliEntries = new HashMap<UUID, ConfiguredObjectRecord>();
        if (managementModeHttpPortOverride != 0) {
            ConfiguredObjectRecord entry = this.createCLIPortEntry(managementModeHttpPortOverride, Protocol.HTTP);
            cliEntries.put(entry.getId(), entry);
        }
        return cliEntries;
    }

    private ConfiguredObjectRecord createCLIPortEntry(int port, Protocol protocol) {
        ConfiguredObjectRecord parent = this.findBroker();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("port", port);
        attributes.put("protocols", Collections.singleton(protocol));
        attributes.put("name", MANAGEMENT_MODE_PORT_PREFIX + protocol.name());
        attributes.put("authenticationProvider", "MANAGEMENT_MODE_AUTHENTICATION");
        ConfiguredObjectRecordImpl portEntry = new ConfiguredObjectRecordImpl(UUID.randomUUID(), PORT_TYPE, attributes, Collections.singletonMap(parent.getType(), parent.getId()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add management mode port configuration " + portEntry + " for port " + port + " and protocol " + protocol);
        }
        return portEntry;
    }

    private ConfiguredObjectRecord findBroker() {
        for (ConfiguredObjectRecord record : this._records.values()) {
            if (!record.getType().equals(Broker.class.getSimpleName())) continue;
            return record;
        }
        return null;
    }

    private Map<UUID, Object> quiesceEntries(SystemConfig<?> options, List<ConfiguredObjectRecord> records) {
        HashMap<UUID, Object> quiescedEntries = new HashMap<UUID, Object>();
        int managementModeHttpPortOverride = options.getManagementModeHttpPortOverride();
        for (ConfiguredObjectRecord entry : records) {
            String entryType = entry.getType();
            Map<String, Object> attributes = entry.getAttributes();
            boolean quiesce = false;
            if (VIRTUAL_HOST_NODE_TYPE.equals(entryType) && options.isManagementModeQuiesceVirtualHosts()) {
                quiesce = true;
            } else if (PORT_TYPE.equals(entryType)) {
                if (attributes == null) {
                    throw new IllegalConfigurationException("Port attributes are not set in " + entry);
                }
                Set<Protocol> protocols = this.getPortProtocolsAttribute(attributes);
                if (protocols == null) {
                    quiesce = true;
                } else {
                    block4: for (Protocol protocol : protocols) {
                        switch (protocol) {
                            case HTTP: {
                                quiesce = managementModeHttpPortOverride > 0;
                                continue block4;
                            }
                        }
                        quiesce = true;
                    }
                }
            }
            if (!quiesce) continue;
            LOGGER.debug("Management mode quiescing entry {}", (Object)entry);
            quiescedEntries.put(entry.getId(), attributes.get(ATTRIBUTE_DESIRED_STATE));
        }
        return quiescedEntries;
    }

    private Set<Protocol> getPortProtocolsAttribute(Map<String, Object> attributes) {
        Object object = attributes.get("protocols");
        if (object == null) {
            return null;
        }
        Model model = this._parent.getModel();
        ConfiguredObjectTypeRegistry typeRegistry = model.getTypeRegistry();
        Map<String, ConfiguredObjectAttribute<?, ?>> attributeTypes = typeRegistry.getAttributeTypes(Port.class);
        ConfiguredSettableAttribute protocolsAttribute = (ConfiguredSettableAttribute)attributeTypes.get("protocols");
        return (Set)protocolsAttribute.convert(object, this._parent);
    }

    private ConfiguredObjectRecord createEntryWithState(ConfiguredObjectRecord entry, Object state) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(entry.getAttributes());
        if (state == null) {
            attributes.remove(ATTRIBUTE_DESIRED_STATE);
        } else {
            attributes.put(ATTRIBUTE_DESIRED_STATE, state);
        }
        return new ConfiguredObjectRecordImpl(entry.getId(), entry.getType(), attributes, entry.getParents());
    }

    public void recoverRecords(List<ConfiguredObjectRecord> records) {
        boolean b = this._systemConfig.getManagementModeHttpPortOverride() > 0;
        for (ConfiguredObjectRecord object : records) {
            String entryType = object.getType();
            Map<String, Object> attributes = object.getAttributes();
            boolean quiesce = false;
            if (VIRTUAL_HOST_NODE_TYPE.equals(entryType) && this._systemConfig.isManagementModeQuiesceVirtualHosts()) {
                quiesce = true;
            } else if (PORT_TYPE.equals(entryType)) {
                if (attributes == null) {
                    throw new IllegalConfigurationException("Port attributes are not set in " + object);
                }
                Set<Protocol> protocols = this.getPortProtocolsAttribute(attributes);
                if (protocols == null) {
                    quiesce = true;
                } else {
                    block4: for (Protocol protocol : protocols) {
                        switch (protocol) {
                            case HTTP: {
                                quiesce = b;
                                continue block4;
                            }
                        }
                        quiesce = true;
                    }
                }
            }
            if (quiesce) {
                LOGGER.debug("Management mode quiescing entry {}", (Object)object);
                this._quiescedEntriesOriginalState.put(object.getId(), attributes.get(ATTRIBUTE_DESIRED_STATE));
                HashMap<String, Object> modifiedAttributes = new HashMap<String, Object>(attributes);
                modifiedAttributes.put(ATTRIBUTE_DESIRED_STATE, (Object)State.QUIESCED);
                ConfiguredObjectRecordImpl record = new ConfiguredObjectRecordImpl(object.getId(), object.getType(), modifiedAttributes, object.getParents());
                this._records.put(record.getId(), record);
                continue;
            }
            this._records.put(object.getId(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertState(StoreState state) {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != state) {
                throw new IllegalStateException("The store must be in state " + state + " to perform this operation, but it is in state " + this._state + " instead");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(StoreState oldState, StoreState newState) {
        Object object = this._lock;
        synchronized (object) {
            this.assertState(oldState);
            this._state = newState;
        }
    }

    private static class UnderlyingStoreRecoveringObjectRecordHandler
    implements ConfiguredObjectRecordHandler {
        private final List<ConfiguredObjectRecord> _recoveredRecords = new ArrayList<ConfiguredObjectRecord>();

        private UnderlyingStoreRecoveringObjectRecordHandler() {
        }

        @Override
        public void handle(ConfiguredObjectRecord record) {
            this._recoveredRecords.add(record);
        }

        public List<ConfiguredObjectRecord> getRecoveredRecords() {
            return this._recoveredRecords;
        }
    }

    private static enum StoreState {
        CLOSED,
        CONFIGURED,
        OPEN;

    }
}

