/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.configuration.CommonProperties;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.plugin.ConnectionPropertyEnricher;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.transport.AMQPConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class StandardConnectionPropertyEnricher
implements ConnectionPropertyEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(StandardConnectionPropertyEnricher.class);

    @Override
    public Map<String, Object> addConnectionProperties(AMQPConnection<?> connection, Map<String, Object> existingProperties) {
        LinkedHashMap<String, Object> modifiedProperties = new LinkedHashMap<String, Object>(existingProperties);
        Broker<?> broker = connection.getBroker();
        modifiedProperties.put("product", CommonProperties.getProductName());
        modifiedProperties.put("version", CommonProperties.getReleaseVersion());
        modifiedProperties.put("qpid.build", CommonProperties.getBuildVersion());
        modifiedProperties.put("qpid.instance_name", broker.getName());
        modifiedProperties.put("qpid.virtualhost_properties_supported", String.valueOf(broker.isVirtualHostPropertiesNodeEnabled()));
        modifiedProperties.put("qpid.message_compression_supported", String.valueOf(broker.isMessageCompressionEnabled()));
        modifiedProperties.put("qpid.queue_lifetime_supported", Boolean.TRUE.toString());
        switch (connection.getProtocol()) {
            case AMQP_0_8: 
            case AMQP_0_9: 
            case AMQP_0_9_1: {
                modifiedProperties.put("qpid.confirmed_publish_supported", Boolean.TRUE.toString());
                modifiedProperties.put("qpid.close_when_no_route", String.valueOf(connection.getPort().getCloseWhenNoRoute()));
                break;
            }
            case AMQP_0_10: {
                modifiedProperties.put("qpid.federation_tag", broker.getId().toString());
                List<String> features = StandardConnectionPropertyEnricher.getFeatures(broker);
                if (features.size() <= 0) break;
                modifiedProperties.put("qpid.features", features);
                break;
            }
            case AMQP_1_0: {
                modifiedProperties.remove("qpid.message_compression_supported");
                modifiedProperties.remove("qpid.queue_lifetime_supported");
                break;
            }
            default: {
                LOG.info("Unexpected protocol: " + connection.getProtocol());
            }
        }
        return Collections.unmodifiableMap(modifiedProperties);
    }

    private static List<String> getFeatures(Broker<?> broker) {
        String brokerDisabledFeatures = System.getProperty("qpid.broker_disabled_features");
        ArrayList<String> features = new ArrayList<String>();
        if (brokerDisabledFeatures == null || !brokerDisabledFeatures.contains("qpid.jms-selector")) {
            features.add("qpid.jms-selector");
        }
        return Collections.unmodifiableList(features);
    }

    @Override
    public String getType() {
        return "STANDARD";
    }
}

