/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.connection;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.plugin.ConnectionPropertyEnricher;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.transport.AMQPConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class SuppliedMapConnectionPropertyEnricher
implements ConnectionPropertyEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(SuppliedMapConnectionPropertyEnricher.class);
    private static final String PROPERTY_MAP_CONTEXT = "qpid.connection.property_map";

    @Override
    public Map<String, Object> addConnectionProperties(AMQPConnection<?> connection, Map<String, Object> existingProperties) {
        if (connection.getContextKeys(false).contains(PROPERTY_MAP_CONTEXT)) {
            LinkedHashMap<String, Object> modifiedProperties = new LinkedHashMap<String, Object>(existingProperties);
            Map map = connection.getContextValue(Map.class, PROPERTY_MAP_CONTEXT);
            modifiedProperties.putAll(map);
            return Collections.unmodifiableMap(modifiedProperties);
        }
        return existingProperties;
    }

    @Override
    public String getType() {
        return "SUPPLIED-MAP";
    }
}

