/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class VirtualHostMessages {
    private static final ResourceBundle MESSAGES;
    private static final Locale CURRENT_LOCALE;
    public static final String VIRTUALHOST_LOG_HIERARCHY = "qpid.message.virtualhost";
    public static final String CLOSE_LOG_HIERARCHY = "qpid.message.virtualhost.close";
    public static final String CREATE_LOG_HIERARCHY = "qpid.message.virtualhost.create";
    public static final String DELETE_LOG_HIERARCHY = "qpid.message.virtualhost.delete";
    public static final String ERRORED_LOG_HIERARCHY = "qpid.message.virtualhost.errored";
    public static final String FILESYSTEM_FULL_LOG_HIERARCHY = "qpid.message.virtualhost.filesystem_full";
    public static final String FILESYSTEM_NOTFULL_LOG_HIERARCHY = "qpid.message.virtualhost.filesystem_notfull";
    public static final String OPEN_LOG_HIERARCHY = "qpid.message.virtualhost.open";
    public static final String OPERATION_LOG_HIERARCHY = "qpid.message.virtualhost.operation";
    public static final String UPDATE_LOG_HIERARCHY = "qpid.message.virtualhost.update";

    public static LogMessage CLOSE(String param1) {
        String rawMessage = MESSAGES.getString("CLOSE");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.CLOSE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage CREATE(String param1, String param2, String param3) {
        String rawMessage = MESSAGES.getString("CREATE");
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.CREATE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage DELETE(String param1, String param2) {
        String rawMessage = MESSAGES.getString("DELETE");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.DELETE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage ERRORED(String param1) {
        String rawMessage = MESSAGES.getString("ERRORED");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.ERRORED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage FILESYSTEM_FULL(Number param1) {
        String rawMessage = MESSAGES.getString("FILESYSTEM_FULL");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.FILESYSTEM_FULL_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage FILESYSTEM_NOTFULL(Number param1) {
        String rawMessage = MESSAGES.getString("FILESYSTEM_NOTFULL");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.FILESYSTEM_NOTFULL_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPEN(String param1, String param2) {
        String rawMessage = MESSAGES.getString("OPEN");
        Object[] messageArguments = new Object[]{param1, param2};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.OPEN_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPERATION(String param1) {
        String rawMessage = MESSAGES.getString("OPERATION");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.OPERATION_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage UPDATE(String param1, String param2, String param3) {
        String rawMessage = MESSAGES.getString("UPDATE");
        Object[] messageArguments = new Object[]{param1, param2, param3};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return VirtualHostMessages.UPDATE_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private VirtualHostMessages() {
    }

    static {
        Locale locale = Locale.US;
        String localeSetting = System.getProperty("qpid.broker_locale");
        if (localeSetting != null) {
            String[] localeParts = localeSetting.split("_");
            String language = localeParts.length > 0 ? localeParts[0] : "";
            String country = localeParts.length > 1 ? localeParts[1] : "";
            String variant = "";
            if (localeParts.length > 2) {
                variant = localeSetting.substring(language.length() + 1 + country.length() + 1);
            }
            locale = new Locale(language, country, variant);
        }
        CURRENT_LOCALE = locale;
        LoggerFactory.getLogger((String)VIRTUALHOST_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CLOSE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CREATE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)DELETE_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)ERRORED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)FILESYSTEM_FULL_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)FILESYSTEM_NOTFULL_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPEN_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPERATION_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)UPDATE_LOG_HIERARCHY);
        MESSAGES = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.VirtualHost_logmessages", CURRENT_LOCALE);
    }
}

