/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mqtt;

import org.eclipse.basyx.aas.aggregator.api.IAASAggregatorFactory;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.extensions.aas.aggregator.mqtt.MqttDecoratingAASAggregatorFactory;
import org.eclipse.basyx.extensions.aas.api.mqtt.MqttDecoratingAASAPIFactory;
import org.eclipse.basyx.extensions.submodel.aggregator.mqtt.MqttDecoratingSubmodelAggregatorFactory;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttDecoratingSubmodelAPIFactory;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.paho.client.mqttv3.MqttClient;

public class MqttAASServerDecorator
implements IAASServerDecorator {
    private MqttClient client;

    public MqttAASServerDecorator(MqttClient client) {
        this.client = client;
    }

    @Override
    public ISubmodelAPIFactory decorateSubmodelAPIFactory(ISubmodelAPIFactory submodelAPIFactory) {
        return new MqttDecoratingSubmodelAPIFactory(submodelAPIFactory, this.client);
    }

    @Override
    public ISubmodelAggregatorFactory decorateSubmodelAggregatorFactory(ISubmodelAggregatorFactory submodelAggregatorFactory) {
        return new MqttDecoratingSubmodelAggregatorFactory(submodelAggregatorFactory, this.client);
    }

    @Override
    public IAASAPIFactory decorateAASAPIFactory(IAASAPIFactory aasAPIFactory) {
        return new MqttDecoratingAASAPIFactory(aasAPIFactory, this.client);
    }

    @Override
    public IAASAggregatorFactory decorateAASAggregatorFactory(IAASAggregatorFactory aasAggregatorFactory) {
        return new MqttDecoratingAASAggregatorFactory(aasAggregatorFactory, this.client);
    }
}

