/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mqtt;

import com.google.common.base.Strings;
import java.security.ProviderException;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerFeature;
import org.eclipse.basyx.components.aas.mqtt.MqttAASServerDecorator;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttAASServerFeature
implements IAASServerFeature {
    private BaSyxMqttConfiguration mqttConfig;
    private MqttClient client;
    private String clientId;

    public MqttAASServerFeature(BaSyxMqttConfiguration mqttConfig, String clientId) {
        this.mqttConfig = mqttConfig;
        this.clientId = clientId;
    }

    @Override
    public void initialize() {
        try {
            String serverEndpoint = this.mqttConfig.getServer();
            MqttConnectOptions options = this.createMqttConnectOptions();
            this.client = new MqttClient(serverEndpoint, this.clientId);
            this.client.connect(options);
        }
        catch (MqttException e) {
            throw new ProviderException("moquette.conf Error ", e);
        }
    }

    protected MqttConnectOptions createMqttConnectOptions() {
        MqttConnectOptions options = new MqttConnectOptions();
        if (!Strings.isNullOrEmpty((String)this.mqttConfig.getUser())) {
            options.setUserName(this.mqttConfig.getUser());
            options.setPassword(this.mqttConfig.getPass().toCharArray());
        }
        return options;
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public IAASServerDecorator getDecorator() {
        return new MqttAASServerDecorator(this.client);
    }
}

