/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.HttpK8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.support.TimeUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;

public class ServerHttpJavaK8SProxy {
    private static int localPort = 4411;
    private static String serverIP = "Empty";
    private static String serverPort = "6443";
    private static boolean tlsCheck = false;
    private static ArrayList<ServerSocket> serverSocketList = new ArrayList();

    public static int getLocalPort() {
        return localPort;
    }

    public static void setLocalPort(int localPort) {
        ServerHttpJavaK8SProxy.localPort = localPort;
    }

    public static String getServerIP() {
        return serverIP;
    }

    public static void setServerIP(String serverIP) {
        ServerHttpJavaK8SProxy.serverIP = serverIP;
    }

    public static String getServerPort() {
        return serverPort;
    }

    public static void setServerPort(String serverPort) {
        ServerHttpJavaK8SProxy.serverPort = serverPort;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            serverIP = args[0];
            System.out.println("Api Server IP:" + serverIP);
        } else {
            System.out.println("No Api Server IP passed");
        }
        if (args.length > 1) {
            tlsCheck = Boolean.parseBoolean(args[1]);
            if (tlsCheck) {
                System.out.println("Security option Enabled");
            } else {
                System.out.println("Security option Disabled");
            }
        } else {
            System.out.println("No security option passed, default false");
        }
        Thread requestThread = new Thread(){

            @Override
            public void run() {
                try {
                    HttpK8SJavaProxy httpJavaK8SProxy = new HttpK8SJavaProxy(ProxyType.MasterProxy, serverIP, serverPort, tlsCheck);
                    ServerHttpJavaK8SProxy.startMultiThreaded((K8SJavaProxy)httpJavaK8SProxy, localPort);
                }
                catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
                    System.err.println("Exception in the starting the multi-threads method");
                    e.printStackTrace();
                }
            }
        };
        requestThread.start();
        while (true) {
            if (new File("/tmp/EndServerRun.k8s").exists()) {
                try {
                    serverSocketList.get(0).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            TimeUtils.sleep((int)1);
        }
    }

    public static void startMultiThreaded(final K8SJavaProxy httpJavaK8SProxy, int localPort) throws UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, InvalidKeySpecException, IOException {
        if (new File("/tmp/EndServerRun.k8s").exists()) {
            System.out.println("/tmp/EndServerRun.k8s is exist and stop the Client");
            return;
        }
        ServerSocket serverSocket = httpJavaK8SProxy.getServerSocket(localPort, null, null, null, tlsCheck);
        serverSocketList.add(serverSocket);
        System.out.println("Started multi-threaded server at localhost port " + localPort);
        File file = new File("ServerReady.k8s");
        file.createNewFile();
        while (true) {
            final Socket socket = serverSocket.accept();
            Thread requestThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    InputStream reader = null;
                    FilterOutputStream writer = null;
                    byte[] requestByte = null;
                    try {
                        while (true) {
                            reader = socket.getInputStream();
                            writer = new BufferedOutputStream(socket.getOutputStream());
                            requestByte = httpJavaK8SProxy.extractK8SRequestByte(reader);
                            if (requestByte != null) {
                                K8SRequest request = httpJavaK8SProxy.createK8SRequest(requestByte);
                                byte[] responseString = httpJavaK8SProxy.sendK8SRequest((BufferedOutputStream)writer, request);
                                writer.write(responseString);
                                ((BufferedOutputStream)writer).flush();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (SocketException e) {
                        if (e.getMessage().contentEquals("Socket input is already shutdown")) {
                            System.out.println(e.getMessage());
                        } else {
                            System.err.println("SocketException while creating response");
                            e.printStackTrace();
                        }
                    }
                    catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                        System.err.println("Exception while creating response");
                        e.printStackTrace();
                        System.out.println("socket thread ends Throwable");
                    }
                    finally {
                        try {
                            writer.close();
                            reader.close();
                        }
                        catch (IOException e) {
                            System.err.println("Could not close the streams");
                            e.printStackTrace();
                        }
                    }
                }
            };
            requestThread.start();
        }
    }
}

