/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.WorkerAasCreator;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class WorkerK8SAas {
    private static String serverIP;
    private static String serverPort;
    private static Submodel submodel;
    private int vabPort;
    private int aasPort;

    public WorkerK8SAas(String serverIP, String serverPort, int vabPort, int aasPort) {
        WorkerK8SAas.serverIP = serverIP;
        WorkerK8SAas.serverPort = serverPort;
        this.vabPort = vabPort;
        this.aasPort = aasPort;
        ServerAddress aasServer = new ServerAddress(Schema.HTTP, serverIP, Integer.parseInt(serverPort));
        Endpoint aasServerRegistry = new Endpoint(aasServer, "registry");
        BasicSetupSpec spec = new BasicSetupSpec(aasServerRegistry, aasServer);
        AasFactory factory = AasFactory.getInstance();
        Aas aas = null;
        try {
            aas = factory.obtainRegistry((SetupSpec)spec).retrieveAas("urn:::AAS:::MasterK8SAas#");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        submodel = aas.getSubmodel("MasterK8SAasService");
    }

    public String getServerIP() {
        return serverIP;
    }

    public void setServerIP(String serverIP) {
        WorkerK8SAas.serverIP = serverIP;
    }

    public String getServerPort() {
        return serverPort;
    }

    public void setServerPort(String serverPort) {
        WorkerK8SAas.serverPort = serverPort;
    }

    public int getVabPort() {
        return this.vabPort;
    }

    public void setVabPort(int vabPort) {
        this.vabPort = vabPort;
    }

    public int getAasPort() {
        return this.aasPort;
    }

    public void setAasPort(int aasPort) {
        this.aasPort = aasPort;
    }

    public ArrayList<Server> startLocalAas() throws IOException {
        ServerAddress vabServer = new ServerAddress(Schema.HTTP, this.vabPort);
        ServerAddress aasServer = new ServerAddress(Schema.HTTP, this.aasPort);
        Endpoint aasServerRegistry = new Endpoint(aasServer, "registry");
        BasicSetupSpec spec = new BasicSetupSpec(aasServerRegistry, aasServer);
        spec.setAssetServerAddress(vabServer, "");
        Aas aas = WorkerAasCreator.createAas((ServerAddress)vabServer);
        ProtocolServerBuilder pBuilder = AasFactory.getInstance().createProtocolServerBuilder((SetupSpec)spec);
        pBuilder.defineProperty("name", () -> "K8SAasProperty", null);
        pBuilder.defineProperty("version", () -> "0.0.1", null);
        pBuilder.defineProperty("description", () -> "K8S AAS", null);
        pBuilder.defineOperation("sendToAAS", params -> WorkerK8SAas.sendToAAS(params));
        pBuilder.defineOperation("sendWatchToAAS", params -> WorkerK8SAas.sendWatchToAAS(params));
        Server server = (Server)pBuilder.build();
        server.start();
        AasServer httpServer = AasFactory.getInstance().createDeploymentRecipe((SetupSpec)spec).forRegistry().deploy(aas).createServer(new String[0]).start();
        ArrayList<Server> servers = new ArrayList<Server>();
        servers.add((Server)httpServer);
        servers.add(server);
        return servers;
    }

    private static Object sendToAAS(Object[] params) {
        String response = null;
        String requestString = null;
        try {
            if (params.length > 0 && params[0] != null) {
                requestString = params[0].toString();
            }
            Operation operation = submodel.getOperation("sendToK8S");
            response = (String)operation.invoke(new Object[]{requestString});
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return response;
    }

    private static Object sendWatchToAAS(Object[] params) {
        String response = null;
        String requestString = null;
        try {
            if (params.length > 0 && params[0] != null) {
                requestString = params[0].toString();
            }
            Operation operation = submodel.getOperation("sendWatchToK8S");
            response = (String)operation.invoke(new Object[]{requestString});
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return response;
    }
}

