/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.util.IOUtil;
import org.jetbrains.annotations.NotNull;

class EnvironmentBackupStrategyImpl
extends BackupStrategy {
    @NotNull
    private final EnvironmentImpl environment;

    public EnvironmentBackupStrategyImpl(@NotNull EnvironmentImpl environment) {
        this.environment = environment;
    }

    public void beforeBackup() {
        this.environment.suspendGC();
        this.environment.flushAndSync();
    }

    public Iterable<VirtualFileDescriptor> getContents() {
        return new Iterable<VirtualFileDescriptor>(){
            private final File[] files;
            private int i;
            private VirtualFileDescriptor next;
            {
                this.files = IOUtil.listFiles((File)new File(EnvironmentBackupStrategyImpl.this.environment.getLog().getLocation()));
                this.i = 0;
            }

            @Override
            @NotNull
            public Iterator<VirtualFileDescriptor> iterator() {
                return new Iterator<VirtualFileDescriptor>(){

                    @Override
                    public boolean hasNext() {
                        if (next != null) {
                            return true;
                        }
                        while (i < files.length) {
                            long fileSize;
                            File file = files[i++];
                            if (!file.isFile() || (fileSize = file.length()) == 0L || !file.getName().endsWith(".xd")) continue;
                            next = (VirtualFileDescriptor)new BackupStrategy.FileDescriptor(file, "", fileSize);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public VirtualFileDescriptor next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        VirtualFileDescriptor result = next;
                        next = null;
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void afterBackup() {
        this.environment.resumeGC();
    }
}

