/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import jetbrains.exodus.io.AbstractDataWriter;
import jetbrains.exodus.io.LockingManager;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataWriter
extends AbstractDataWriter {
    private static final Logger logger = LoggerFactory.getLogger(FileDataWriter.class);
    @NotNull
    private final File dir;
    @Nullable
    private FileChannel dirChannel;
    @NotNull
    private final LockingManager lockingManager;
    @Nullable
    private RandomAccessFile file = null;

    public FileDataWriter(@NotNull File directory) {
        this(directory, null);
    }

    public FileDataWriter(@NotNull File directory, @Nullable String lockId) {
        this.dir = directory;
        FileChannel channel = null;
        try {
            channel = FileChannel.open(this.dir.toPath(), new OpenOption[0]);
            channel.force(false);
        }
        catch (IOException e) {
            this.warnCantFsyncDirectory();
        }
        this.dirChannel = channel;
        this.lockingManager = new LockingManager(this.dir, lockId);
    }

    @Override
    public void write(byte[] b, int off, int len) throws ExodusException {
        RandomAccessFile file = this.file;
        if (file == null) {
            throw new ExodusException("Can't write, FileDataWriter is closed");
        }
        try {
            file.write(b, off, len);
        }
        catch (IOException ioe) {
            if (this.lockingManager.getUsableSpace() < (long)len) {
                throw new OutOfDiskSpaceException((Throwable)ioe);
            }
            throw new ExodusException("Can't write", (Throwable)ioe);
        }
    }

    @Override
    public boolean lock(long timeout) {
        return this.lockingManager.lock(timeout);
    }

    @Override
    public boolean release() {
        return this.lockingManager.release();
    }

    @Override
    public String lockInfo() {
        return this.lockingManager.lockInfo();
    }

    @Override
    protected void syncImpl() {
        RandomAccessFile file = this.file;
        if (file != null) {
            FileDataWriter.forceSync(file);
        }
    }

    @Override
    protected void closeImpl() {
        RandomAccessFile file = this.file;
        if (file == null) {
            throw new ExodusException("Can't close already closed FileDataWriter");
        }
        try {
            file.close();
            this.file = null;
        }
        catch (IOException e) {
            throw new ExodusException("Can't close FileDataWriter", (Throwable)e);
        }
    }

    @Override
    protected void openOrCreateBlockImpl(long address, long length) {
        try {
            RandomAccessFile result = new RandomAccessFile(new File(this.dir, LogUtil.getLogFilename(address)), "rw");
            result.seek(length);
            if (length != result.length()) {
                result.setLength(length);
                FileDataWriter.forceSync(result);
            }
            this.file = result;
        }
        catch (IOException ioe) {
            throw new ExodusException((Throwable)ioe);
        }
    }

    private static void forceSync(@NotNull RandomAccessFile file) {
        block3: {
            try {
                FileChannel channel = file.getChannel();
                channel.force(false);
            }
            catch (ClosedChannelException channel) {
            }
            catch (IOException ioe) {
                if (!file.getChannel().isOpen()) break block3;
                throw new ExodusException((Throwable)ioe);
            }
        }
    }

    @Override
    public void syncDirectory() {
        FileChannel dirChannel = this.dirChannel;
        if (dirChannel != null) {
            try {
                dirChannel.force(false);
            }
            catch (IOException e) {
                this.warnCantFsyncDirectory();
            }
        }
    }

    private void warnCantFsyncDirectory() {
        this.dirChannel = null;
        logger.warn("Can't open directory channel. Log directory fsync won't be performed.");
    }
}

