/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class LogCache {
    protected static final int MINIMUM_PAGE_SIZE = 1024;
    protected static final int DEFAULT_OPEN_FILES_COUNT = 16;
    protected static final int MINIMUM_MEM_USAGE_PERCENT = 5;
    protected static final int MAXIMUM_MEM_USAGE_PERCENT = 95;
    protected static final int CONCURRENT_CACHE_GENERATION_COUNT = 2;
    private static final ConcurrentLongObjectCache<byte[]> TAIL_PAGES_CACHE = new ConcurrentLongObjectCache(10);
    protected final long memoryUsage;
    protected final int memoryUsagePercentage;
    protected final int pageSize;

    protected LogCache(long memoryUsage, int pageSize) {
        LogCache.checkPageSize(pageSize);
        this.pageSize = pageSize;
        if (LogCache.integerLogarithm(pageSize) < 0) {
            throw new InvalidSettingException("Log cache bytes size should be a power of 2: " + pageSize);
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (maxMemory <= memoryUsage) {
            throw new InvalidSettingException("Memory usage cannot be greater than JVM maximum memory");
        }
        this.memoryUsage = memoryUsage;
        this.memoryUsagePercentage = 0;
    }

    protected LogCache(int memoryUsagePercentage, int pageSize) {
        LogCache.checkPageSize(pageSize);
        if (memoryUsagePercentage < 5) {
            throw new InvalidSettingException("Memory usage percent cannot be less than 5");
        }
        if (memoryUsagePercentage > 95) {
            throw new InvalidSettingException("Memory usage percent cannot be greater than 95");
        }
        this.pageSize = pageSize;
        if (LogCache.integerLogarithm(pageSize) < 0) {
            throw new InvalidSettingException("Log cache bytes size should be a power of 2: " + pageSize);
        }
        long maxMemory = Runtime.getRuntime().maxMemory();
        this.memoryUsage = maxMemory == Long.MAX_VALUE ? Long.MAX_VALUE : maxMemory / 100L * (long)memoryUsagePercentage;
        this.memoryUsagePercentage = memoryUsagePercentage;
    }

    abstract void clear();

    abstract float hitRate();

    abstract void cachePage(@NotNull Log var1, long var2, @NotNull byte[] var4);

    @NotNull
    abstract byte[] getPage(@NotNull Log var1, long var2);

    @NotNull
    abstract ArrayByteIterable getPageIterable(@NotNull Log var1, long var2);

    abstract void removePage(@NotNull Log var1, long var2);

    @NotNull
    protected byte[] readFullPage(Log log, long pageAddress) {
        byte[] page = this.allocPage();
        int bytesRead = log.readBytes(page, pageAddress);
        if (bytesRead != this.pageSize) {
            throw new ExodusException("Can't read full bytes from log [" + log.getLocation() + "] with address " + pageAddress + " (file " + LogUtil.getLogFilename(log.getFileAddress(pageAddress)) + "), offset: " + pageAddress % log.getFileLengthBound() + ", read: " + bytesRead);
        }
        return page;
    }

    @NotNull
    byte[] allocPage() {
        return new byte[this.pageSize];
    }

    private static void checkPageSize(int pageSize) throws InvalidSettingException {
        if (pageSize < 1024) {
            throw new InvalidSettingException("Page size cannot be less than 1024");
        }
        if (pageSize % 1024 != 0) {
            throw new InvalidSettingException("Page size should be multiple of 1024");
        }
    }

    private static int integerLogarithm(int i) {
        int result = MathUtil.integerLogarithm((int)i);
        return 1 << result == i ? result : -1;
    }

    protected static byte[] postProcessTailPage(@NotNull byte[] page) {
        if (LogCache.isTailPage(page)) {
            int length = page.length;
            byte[] cachedTailPage = LogCache.getCachedTailPage(length);
            if (cachedTailPage != null) {
                return cachedTailPage;
            }
            TAIL_PAGES_CACHE.cacheObject((long)length, (Object)page);
        }
        return page;
    }

    @Nullable
    static byte[] getCachedTailPage(int cachePageSize) {
        return (byte[])TAIL_PAGES_CACHE.tryKey((long)cachePageSize);
    }

    private static boolean isTailPage(@NotNull byte[] page) {
        for (byte b : page) {
            if (b == -128) continue;
            return false;
        }
        return true;
    }
}

