/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.aascomponent;

import java.util.List;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregatorFactory;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerComponentFactory;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;

public abstract class AbstractAASServerComponentFactory
implements IAASServerComponentFactory {
    protected List<IAASServerDecorator> aasServerDecorators;
    protected IAASRegistry aasServerRegistry;

    @Override
    public IAASAggregator create() {
        ISubmodelAPIFactory submodelAPIFactory = this.createAndDecorateSubmodelAPIFactory();
        ISubmodelAggregatorFactory submodelAggregatorFactory = this.createAndDecorateSubmodelAggregatorFactory(submodelAPIFactory);
        IAASAPIFactory aasAPIFactory = this.createAndDecorateAASAPIFactory();
        IAASAggregatorFactory aasAggregatorFactory = this.createAndDecorateAASAggregatorFactory(aasAPIFactory, submodelAggregatorFactory);
        return aasAggregatorFactory.create();
    }

    private ISubmodelAPIFactory createAndDecorateSubmodelAPIFactory() {
        ISubmodelAPIFactory submodelAPIFactory = this.createSubmodelAPIFactory();
        for (IAASServerDecorator aasServerDecorator : this.aasServerDecorators) {
            submodelAPIFactory = aasServerDecorator.decorateSubmodelAPIFactory(submodelAPIFactory);
        }
        return submodelAPIFactory;
    }

    private ISubmodelAggregatorFactory createAndDecorateSubmodelAggregatorFactory(ISubmodelAPIFactory submodelAPIFactory) {
        ISubmodelAggregatorFactory submodelAggregatorFactory = this.createSubmodelAggregatorFactory(submodelAPIFactory);
        for (IAASServerDecorator aasServerDecorator : this.aasServerDecorators) {
            submodelAggregatorFactory = aasServerDecorator.decorateSubmodelAggregatorFactory(submodelAggregatorFactory);
        }
        return submodelAggregatorFactory;
    }

    private IAASAPIFactory createAndDecorateAASAPIFactory() {
        IAASAPIFactory aasAPIFactory = this.createAASAPIFactory();
        for (IAASServerDecorator aasServerDecorator : this.aasServerDecorators) {
            aasAPIFactory = aasServerDecorator.decorateAASAPIFactory(aasAPIFactory);
        }
        return aasAPIFactory;
    }

    private IAASAggregatorFactory createAndDecorateAASAggregatorFactory(IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        IAASAggregatorFactory aasAggregatorFactory = this.createAASAggregatorFactory(aasAPIFactory, submodelAggregatorFactory);
        for (IAASServerDecorator aasServerDecorator : this.aasServerDecorators) {
            aasAggregatorFactory = aasServerDecorator.decorateAASAggregatorFactory(aasAggregatorFactory);
        }
        return aasAggregatorFactory;
    }

    protected abstract ISubmodelAPIFactory createSubmodelAPIFactory();

    protected abstract ISubmodelAggregatorFactory createSubmodelAggregatorFactory(ISubmodelAPIFactory var1);

    protected abstract IAASAPIFactory createAASAPIFactory();

    protected abstract IAASAggregatorFactory createAASAggregatorFactory(IAASAPIFactory var1, ISubmodelAggregatorFactory var2);
}

