/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.aggregator.api.IAASAggregator;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.map.AssetAdministrationShell;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.restapi.AASModelProvider;
import org.eclipse.basyx.aas.restapi.MultiSubmodelProvider;
import org.eclipse.basyx.aas.restapi.api.IAASAPI;
import org.eclipse.basyx.aas.restapi.api.IAASAPIFactory;
import org.eclipse.basyx.components.aas.mongodb.MongoDBAASAPI;
import org.eclipse.basyx.components.aas.mongodb.MongoDBSubmodelAPI;
import org.eclipse.basyx.components.configuration.BaSyxMongoDBConfiguration;
import org.eclipse.basyx.extensions.shared.authorization.internal.NotAuthorizedException;
import org.eclipse.basyx.submodel.aggregator.SubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregator;
import org.eclipse.basyx.submodel.aggregator.api.ISubmodelAggregatorFactory;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.metamodel.api.reference.IKey;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyType;
import org.eclipse.basyx.submodel.metamodel.map.Submodel;
import org.eclipse.basyx.submodel.restapi.SubmodelProvider;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPIFactory;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.api.IConnectorFactory;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;

public class MongoDBAASAggregator
implements IAASAggregator {
    private static Logger logger = LoggerFactory.getLogger(MongoDBAASAggregator.class);
    private static final String IDSHORTPATH = "idShort";
    private static final String IDPATH = "identification.id";
    protected Map<String, MultiSubmodelProvider> aasProviderMap = new HashMap<String, MultiSubmodelProvider>();
    protected BaSyxMongoDBConfiguration config;
    protected MongoOperations mongoOps;
    protected String aasCollection;
    protected String smCollection;
    private IAASRegistry registry;
    protected IAASAPIFactory aasApiProvider;
    protected ISubmodelAPIFactory smApiProvider;
    @Deprecated
    protected ISubmodelAggregator submodelAggregator;
    protected ISubmodelAggregatorFactory submodelAggregatorFactory;

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config) {
        this.setConfiguration(config);
        this.submodelAggregatorFactory = new SubmodelAggregatorFactory(this.smApiProvider);
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASRegistry registry) {
        this.setConfiguration(config);
        this.registry = registry;
        this.submodelAggregatorFactory = new SubmodelAggregatorFactory(this.smApiProvider);
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setConfiguration(this.config);
        this.submodelAggregatorFactory = new SubmodelAggregatorFactory(this.smApiProvider);
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath, IAASRegistry registry) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setConfiguration(this.config);
        this.submodelAggregatorFactory = new SubmodelAggregatorFactory(this.smApiProvider);
        this.registry = registry;
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator() {
        this("mongodb.properties");
    }

    @Deprecated
    public MongoDBAASAggregator(IAASRegistry registry) {
        this("mongodb.properties", registry);
    }

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASRegistry registry, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this(config, registry, aasAPIFactory, submodelAggregatorFactory, MongoClients.create((String)config.getConnectionUrl()));
    }

    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASRegistry registry, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this.setMongoDBConfiguration(config, client);
        this.config = config;
        this.registry = registry;
        this.aasApiProvider = aasAPIFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this(config, aasAPIFactory, submodelAggregatorFactory, MongoClients.create((String)config.getConnectionUrl()));
    }

    public MongoDBAASAggregator(BaSyxMongoDBConfiguration config, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this.setMongoDBConfiguration(config, client);
        this.config = config;
        this.aasApiProvider = aasAPIFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath, IAASRegistry registry, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setMongoDBConfiguration(this.config, MongoClients.create((String)this.config.getConnectionUrl()));
        this.registry = registry;
        this.aasApiProvider = aasAPIFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.init();
    }

    public MongoDBAASAggregator(String resourceConfigPath, IAASRegistry registry, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setMongoDBConfiguration(this.config, client);
        this.registry = registry;
        this.aasApiProvider = aasAPIFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator(String resourceConfigPath, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setMongoDBConfiguration(this.config, MongoClients.create((String)this.config.getConnectionUrl()));
        this.aasApiProvider = aasAPIFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.init();
    }

    public MongoDBAASAggregator(String resourceConfigPath, IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this.config = new BaSyxMongoDBConfiguration();
        this.config.loadFromResource(resourceConfigPath);
        this.setMongoDBConfiguration(this.config, client);
        this.aasApiProvider = aasAPIFactory;
        this.submodelAggregatorFactory = submodelAggregatorFactory;
        this.init();
    }

    @Deprecated
    public MongoDBAASAggregator(IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory) {
        this("mongodb.properties", aasAPIFactory, submodelAggregatorFactory);
    }

    public MongoDBAASAggregator(IAASAPIFactory aasAPIFactory, ISubmodelAggregatorFactory submodelAggregatorFactory, MongoClient client) {
        this("mongodb.properties", aasAPIFactory, submodelAggregatorFactory, client);
    }

    @Deprecated
    public void setRegistry(IAASRegistry registry) {
        this.registry = registry;
    }

    @Deprecated
    public void setConfiguration(BaSyxMongoDBConfiguration config) {
        this.config = config;
        MongoClient client = MongoClients.create((String)config.getConnectionUrl());
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
        this.aasCollection = config.getAASCollection();
        this.smCollection = config.getSubmodelCollection();
        this.aasApiProvider = aas -> {
            MongoDBAASAPI api = new MongoDBAASAPI(config, aas.getIdentification().getId());
            api.setAAS(aas);
            return api;
        };
        this.smApiProvider = sm -> {
            MongoDBSubmodelAPI api = new MongoDBSubmodelAPI(config, sm.getIdentification().getId());
            api.setSubmodel(sm);
            return api;
        };
    }

    private void setMongoDBConfiguration(BaSyxMongoDBConfiguration config, MongoClient client) {
        this.config = config;
        this.mongoOps = new MongoTemplate(client, config.getDatabase());
        this.aasCollection = config.getAASCollection();
        this.smCollection = config.getSubmodelCollection();
    }

    public void reset() {
        this.mongoOps.dropCollection(this.aasCollection);
        this.mongoOps.dropCollection(this.smCollection);
        this.aasProviderMap.clear();
    }

    private void init() {
        List data = this.mongoOps.findAll(AssetAdministrationShell.class, this.aasCollection);
        for (AssetAdministrationShell aas : data) {
            String aasId = aas.getIdentification().getId();
            logger.info("Adding AAS from DB: " + aasId);
            MongoDBAASAPI aasApi = new MongoDBAASAPI(this.config, aasId);
            MultiSubmodelProvider provider = this.createMultiSubmodelProvider(aasApi);
            this.addSubmodelsFromDB(provider, aas);
            this.aasProviderMap.put(aas.getIdentification().getId(), provider);
        }
    }

    private MultiSubmodelProvider createMultiSubmodelProvider(IAASAPI aasApi) {
        AASModelProvider aasProvider = new AASModelProvider(aasApi);
        HTTPConnectorFactory connProvider = new HTTPConnectorFactory();
        ISubmodelAggregator usedAggregator = this.getSubmodelAggregatorInstance();
        return new MultiSubmodelProvider(aasProvider, this.registry, (IConnectorFactory)connProvider, this.aasApiProvider, usedAggregator);
    }

    private ISubmodelAggregator getSubmodelAggregatorInstance() {
        if (this.submodelAggregatorFactory == null) {
            return this.submodelAggregator;
        }
        return this.submodelAggregatorFactory.create();
    }

    private void addSubmodelsFromDB(MultiSubmodelProvider provider, AssetAdministrationShell aas) {
        Collection submodelRefs = aas.getSubmodelReferences();
        ArrayList<String> smIds = new ArrayList<String>();
        ArrayList<String> smIdShorts = new ArrayList<String>();
        for (IReference ref : submodelRefs) {
            List keys = ref.getKeys();
            IKey lastKey = (IKey)keys.get(keys.size() - 1);
            if (lastKey.getIdType() == KeyType.IDSHORT) {
                smIdShorts.add(lastKey.getValue());
                continue;
            }
            smIds.add(lastKey.getValue());
        }
        for (String idShort : smIdShorts) {
            String id = this.getSubmodelId(idShort);
            if (id == null) continue;
            smIds.add(id);
        }
        for (String id : smIds) {
            logger.info("Adding Submodel from DB: " + id);
            this.addSubmodelProvidersById(id, provider);
        }
    }

    private String getSubmodelId(String idShort) {
        Submodel sm = (Submodel)this.mongoOps.findOne(Query.query((CriteriaDefinition)Criteria.where((String)IDSHORTPATH).is((Object)idShort)), Submodel.class);
        if (sm != null) {
            return sm.getIdentification().getId();
        }
        return null;
    }

    private void addSubmodelProvidersById(String smId, MultiSubmodelProvider provider) {
        MongoDBSubmodelAPI smApi = new MongoDBSubmodelAPI(this.config, smId);
        SubmodelProvider smProvider = new SubmodelProvider((ISubmodelAPI)smApi);
        provider.addSubmodel(smProvider);
    }

    public Collection<IAssetAdministrationShell> getAASList() {
        return this.aasProviderMap.values().stream().map(p -> {
            try {
                return p.getValue("/aas");
            }
            catch (NotAuthorizedException e) {
                return null;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new RuntimeException();
            }
        }).filter(Objects::nonNull).map(m -> {
            AssetAdministrationShell aas = new AssetAdministrationShell();
            aas.putAll((Map)m);
            return aas;
        }).collect(Collectors.toList());
    }

    public IAssetAdministrationShell getAAS(IIdentifier aasId) {
        IModelProvider aasProvider = this.getAASProvider(aasId);
        Map aasMap = (Map)aasProvider.getValue("/aas");
        return AssetAdministrationShell.createAsFacade((Map)aasMap);
    }

    public void createAAS(AssetAdministrationShell aas) {
        IAASAPI aasApi = this.aasApiProvider.create(aas);
        MultiSubmodelProvider provider = this.createMultiSubmodelProvider(aasApi);
        this.aasProviderMap.put(aas.getIdentification().getId(), provider);
    }

    public void updateAAS(AssetAdministrationShell aas) {
        MultiSubmodelProvider oldProvider = (MultiSubmodelProvider)this.getAASProvider(aas.getIdentification());
        IAASAPI aasApi = this.aasApiProvider.create(aas);
        AASModelProvider contentProvider = new AASModelProvider(aasApi);
        IConnectorFactory connectorFactory = oldProvider.getConnectorFactory();
        MultiSubmodelProvider updatedProvider = new MultiSubmodelProvider(contentProvider, this.registry, connectorFactory, this.aasApiProvider, oldProvider.getSmAggregator());
        this.aasProviderMap.put(aas.getIdentification().getId(), updatedProvider);
    }

    public void deleteAAS(IIdentifier aasId) {
        Query hasId = Query.query((CriteriaDefinition)Criteria.where((String)IDPATH).is((Object)aasId.getId()));
        this.mongoOps.remove(hasId, this.aasCollection);
        this.aasProviderMap.remove(aasId.getId());
    }

    public MultiSubmodelProvider getProviderForAASId(String aasId) {
        return this.aasProviderMap.get(aasId);
    }

    public IModelProvider getAASProvider(IIdentifier aasId) {
        MultiSubmodelProvider provider = this.aasProviderMap.get(aasId.getId());
        if (provider == null) {
            throw new ResourceNotFoundException("AAS with Id " + aasId.getId() + " does not exist");
        }
        return provider;
    }
}

