/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.aas.mqtt;

import java.security.ProviderException;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerDecorator;
import org.eclipse.basyx.components.aas.aascomponent.IAASServerFeature;
import org.eclipse.basyx.components.aas.mqtt.MqttAASServerFeature;
import org.eclipse.basyx.components.aas.mqtt.MqttV2AASServerDecorator;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.extensions.shared.encoding.IEncoder;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttV2AASServerFeature
implements IAASServerFeature {
    private BaSyxMqttConfiguration mqttConfig;
    private MqttClient client;
    private String clientId;
    private String aasRepoId;
    private IEncoder idEncoder;

    public MqttV2AASServerFeature(BaSyxMqttConfiguration mqttConfig, String clientId, String aasRepoId, IEncoder idEncoder) {
        this.mqttConfig = mqttConfig;
        this.clientId = clientId;
        this.aasRepoId = aasRepoId;
        this.idEncoder = idEncoder;
    }

    @Override
    public void initialize() {
        MqttAASServerFeature mqttAASServerFeature = new MqttAASServerFeature(this.mqttConfig, this.clientId);
        try {
            String serverEndpoint = this.mqttConfig.getServer();
            MqttConnectOptions options = mqttAASServerFeature.createMqttConnectOptions();
            this.client = new MqttClient(serverEndpoint, this.clientId);
            this.client.connect(options);
        }
        catch (MqttException e) {
            throw new ProviderException("moquette.conf Error ", e);
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public IAASServerDecorator getDecorator() {
        return new MqttV2AASServerDecorator(this.client, this.aasRepoId, this.idEncoder);
    }
}

