/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.test.amqp.qpid;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.apache.qpid.server.SystemLauncher;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.transport.AbstractTestServer;

public class TestQpidServer
extends AbstractTestServer {
    public static final String KEYSTORE_PASSWORD = "a1234567";
    public static final String KEY_ALIAS = "qpid";
    private SystemLauncher systemLauncher;
    private ServerAddress addr;

    public TestQpidServer(ServerAddress addr) {
        this.addr = addr;
    }

    public Server start() {
        try {
            System.setProperty("qpid.amqp_port", Integer.toString(this.addr.getPort()));
            this.systemLauncher = new SystemLauncher();
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            File f = new File(TestQpidServer.getConfigDir((String)"./src/test"), "config.json");
            if (!f.exists()) {
                f = new File(new File(TestQpidServer.getConfigDir((String)"./src/test"), "qpidCfg"), "config.json");
            }
            System.out.println("Qpid: Using configuration directory: " + String.valueOf(f));
            URL initialConfig = f.toURI().toURL();
            File certDir = f.getParentFile();
            System.setProperty("qpid.cert_dir", certDir.toURI().toURL().toExternalForm());
            System.setProperty("store.filesystem.maxUsagePercent", "99");
            attributes.put("type", "Memory");
            attributes.put("initialConfigurationLocation", initialConfig.toExternalForm());
            attributes.put("startupLoggedToSystemOut", true);
            attributes.put("initialSystemPropertiesLocation", "");
            this.systemLauncher.startup(attributes);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
        }
        return this;
    }

    public void stop(boolean dispose) {
        if (null != this.systemLauncher) {
            try {
                this.systemLauncher.shutdown();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        if (TestQpidServer.applyBaseDir((String[])args, (int)1, (String)"./src/test") != null) {
            File tmpWork = new File(FileUtils.getTempDirectory(), KEY_ALIAS);
            FileUtils.deleteQuietly((File)tmpWork);
            System.setProperty("QPID_WORK", tmpWork.getAbsolutePath());
        }
        TestQpidServer server = new TestQpidServer(new ServerAddress(Schema.IGNORE, TestQpidServer.getInteger((String[])args, (int)8883)));
        server.start();
    }
}

