/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.configuration;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.basyx.components.configuration.BaSyxConfiguration;

public class BaSyxSecurityConfiguration
extends BaSyxConfiguration {
    public static final String ENV_PREFIX = "BaSyxSecurity_";
    public static final String FEATURE_ENABLED = "Enabled";
    public static final String FEATURE_DISABLED = "Disabled";
    public static final String DEFAULT_AUTHORIZATION_STRATEGY_SIMPLERBAC_RULES_FILE_PATH = "/rbac_rules.json";
    public static final String AUTHORIZATION_STRATEGY = "authorization.strategy";
    public static final String AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER = "authorization.strategy.jwtBearerTokenAuthenticationConfigurationProvider";
    public static final String AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_SERVER_URL = "authorization.strategy.jwtBearerTokenAuthenticationConfigurationProvider.keycloak.serverUrl";
    public static final String AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_REALM = "authorization.strategy.jwtBearerTokenAuthenticationConfigurationProvider.keycloak.realm";
    public static final String AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_AUDIENCE = "authorization.strategy.jwtBearerTokenAuthenticationConfigurationProvider.audience";
    public static final String AUTHORIZATION_STRATEGY_SIMPLERBAC_RULES_FILE_PATH = "authorization.strategy.simpleRbac.rulesFilePath";
    public static final String AUTHORIZATION_STRATEGY_SIMPLERBAC_ROLE_AUTHENTICATOR = "authorization.strategy.simpleRbac.roleAuthenticator";
    public static final String AUTHORIZATION_STRATEGY_SIMPLERBAC_SUBJECT_INFORMATION_PROVIDER = "authorization.strategy.simpleRbac.subjectInformationProvider";
    public static final String AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_GRANTED_AUTHORITY_GRANTED_AUTHORITY_AUTHENTICATOR = "authorization.strategy.grantedAuthority.grantedAuthorityAuthenticator";
    public static final String AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_SUBJECT_INFORMATION_PROVIDER = "authorization.strategy.grantedAuthority.subjectInformationProvider";
    public static final String AUTHORIZATION_STRATEGY_CUSTOM_AUTHORIZERS_PROVIDER = "authorization.strategy.custom.authorizersProvider";
    public static final String AUTHORIZATION_STRATEGY_CUSTOM_SUBJECT_INFORMATION_PROVIDER = "authorization.strategy.custom.subjectInformationProvider";
    public static final String DEFAULT_CONFIG_PATH = "security.properties";
    public static final String DEFAULT_FILE_KEY = "BASYX_SECURITY";

    public static Map<String, String> getDefaultProperties() {
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        defaultProps.put(AUTHORIZATION_STRATEGY_SIMPLERBAC_RULES_FILE_PATH, DEFAULT_AUTHORIZATION_STRATEGY_SIMPLERBAC_RULES_FILE_PATH);
        return defaultProps;
    }

    public BaSyxSecurityConfiguration(Map<String, String> values) {
        super(values);
    }

    public BaSyxSecurityConfiguration() {
        super(BaSyxSecurityConfiguration.getDefaultProperties());
    }

    public void loadFromEnvironmentVariables() {
        String[] properties = new String[]{AUTHORIZATION_STRATEGY, AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER, AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_SERVER_URL, AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_REALM, AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_AUDIENCE, AUTHORIZATION_STRATEGY_SIMPLERBAC_RULES_FILE_PATH, AUTHORIZATION_STRATEGY_SIMPLERBAC_ROLE_AUTHENTICATOR, AUTHORIZATION_STRATEGY_SIMPLERBAC_SUBJECT_INFORMATION_PROVIDER, AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_GRANTED_AUTHORITY_GRANTED_AUTHORITY_AUTHENTICATOR, AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_SUBJECT_INFORMATION_PROVIDER, AUTHORIZATION_STRATEGY_CUSTOM_AUTHORIZERS_PROVIDER, AUTHORIZATION_STRATEGY_CUSTOM_SUBJECT_INFORMATION_PROVIDER};
        this.loadFromEnvironmentVariables(ENV_PREFIX, properties);
    }

    public void loadFromDefaultSource() {
        this.loadFileOrDefaultResource(DEFAULT_FILE_KEY, DEFAULT_CONFIG_PATH);
        this.loadFromEnvironmentVariables();
    }

    public String getAuthorizationStrategy() {
        return this.getProperty(AUTHORIZATION_STRATEGY);
    }

    public void setAuthorizationStrategy(String authorizationStrategy) {
        this.setProperty(AUTHORIZATION_STRATEGY, authorizationStrategy);
    }

    public String getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProvider() {
        return this.getProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER);
    }

    public void setAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProvider(String jwtBearerTokenAuthenticationConfigurationProvider) {
        this.setProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER, jwtBearerTokenAuthenticationConfigurationProvider);
    }

    public String getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakServerUrl() {
        return this.getProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_SERVER_URL);
    }

    public void setAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakServerUrl(String authorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakServerUrl) {
        this.setProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_SERVER_URL, authorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakServerUrl);
    }

    public String getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakRealm() {
        return this.getProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_REALM);
    }

    public void setAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakRealm(String authorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakRealm) {
        this.setProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_KEYCLOAK_REALM, authorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakRealm);
    }

    public String getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderAudience() {
        return this.getProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_AUDIENCE);
    }

    public void setAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderAudience(String authorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderAudience) {
        this.setProperty(AUTHORIZATION_STRATEGY_JWT_BEARER_TOKEN_AUTHENTICATION_CONFIGURATION_PROVIDER_AUDIENCE, authorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderAudience);
    }

    public String getAuthorizationStrategySimpleRbacRulesFilePath() {
        return this.getProperty(AUTHORIZATION_STRATEGY_SIMPLERBAC_RULES_FILE_PATH);
    }

    public void setAuthorizationStrategySimpleRbacRulesFilePath(String authorizationStrategySimpleRbacRulesFilePath) {
        this.setProperty(AUTHORIZATION_STRATEGY_SIMPLERBAC_RULES_FILE_PATH, authorizationStrategySimpleRbacRulesFilePath);
    }

    public String getAuthorizationStrategySimpleRbacSubjectInformationProvider() {
        return this.getProperty(AUTHORIZATION_STRATEGY_SIMPLERBAC_SUBJECT_INFORMATION_PROVIDER);
    }

    public void setAuthorizationStrategySimpleRbacSubjectInformationProvider(String authorizationStrategySimpleRbacSubjectInformationProvider) {
        this.setProperty(AUTHORIZATION_STRATEGY_SIMPLERBAC_SUBJECT_INFORMATION_PROVIDER, authorizationStrategySimpleRbacSubjectInformationProvider);
    }

    public String getAuthorizationStrategySimpleRbacRoleAuthenticator() {
        return this.getProperty(AUTHORIZATION_STRATEGY_SIMPLERBAC_ROLE_AUTHENTICATOR);
    }

    public void setAuthorizationStrategySimpleRbacRoleAuthenticator(String authorizationStrategySimpleRbacRoleAuthenticator) {
        this.setProperty(AUTHORIZATION_STRATEGY_SIMPLERBAC_ROLE_AUTHENTICATOR, authorizationStrategySimpleRbacRoleAuthenticator);
    }

    public String getAuthorizationStrategyGrantedAuthoritySubjectInformationProvider() {
        return this.getProperty(AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_SUBJECT_INFORMATION_PROVIDER);
    }

    public void setAuthorizationStrategyGrantedAuthoritySubjectInformationProvider(String authorizationStrategyGrantedAuthoritySubjectInformationProvider) {
        this.setProperty(AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_SUBJECT_INFORMATION_PROVIDER, authorizationStrategyGrantedAuthoritySubjectInformationProvider);
    }

    public String getAuthorizationStrategyGrantedAuthorityGrantedAuthorityGrantedAuthorityAuthenticator() {
        return this.getProperty(AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_GRANTED_AUTHORITY_GRANTED_AUTHORITY_AUTHENTICATOR);
    }

    public void setAuthorizationStrategyGrantedAuthorityGrantedAuthorityAuthenticator(String authorizationStrategyGrantedAuthorityGrantedAuthorityAuthenticator) {
        this.setProperty(AUTHORIZATION_STRATEGY_GRANTEDAUTHORITY_GRANTED_AUTHORITY_GRANTED_AUTHORITY_AUTHENTICATOR, authorizationStrategyGrantedAuthorityGrantedAuthorityAuthenticator);
    }

    public String getAuthorizationStrategyCustomAuthorizersProvider() {
        return this.getProperty(AUTHORIZATION_STRATEGY_CUSTOM_AUTHORIZERS_PROVIDER);
    }

    public void setAuthorizationStrategyCustomAuthorizersProvider(String authorizationStrategyCustomAuthorizers) {
        this.setProperty(AUTHORIZATION_STRATEGY_CUSTOM_AUTHORIZERS_PROVIDER, authorizationStrategyCustomAuthorizers);
    }

    public String getAuthorizationStrategyCustomSubjectInformationProvider() {
        return this.getProperty(AUTHORIZATION_STRATEGY_CUSTOM_SUBJECT_INFORMATION_PROVIDER);
    }

    public void setAuthorizationStrategyCustomSubjectInformationProvider(String authorizationStrategyCustomSubjectInformationProvider) {
        this.setProperty(AUTHORIZATION_STRATEGY_CUSTOM_SUBJECT_INFORMATION_PROVIDER, authorizationStrategyCustomSubjectInformationProvider);
    }

    public static enum AuthorizationStrategy {
        SimpleRbac,
        GrantedAuthority,
        Custom;

    }
}

