/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.tools.sql.driver;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import org.eclipse.basyx.tools.sql.driver.ISQLDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLDriver
implements ISQLDriver {
    private static Logger logger = LoggerFactory.getLogger(SQLDriver.class);
    protected String userName = null;
    protected String password = null;
    protected String dbPath = null;
    protected String queryPrefix = null;
    protected String qualDriverClass = null;
    protected Connection connect = null;
    protected HikariDataSource ds = null;

    public SQLDriver(String path, String user, String pass, String qryPfx, String qDrvCls) {
        this.userName = user;
        this.password = pass;
        this.dbPath = path;
        this.queryPrefix = qryPfx;
        this.qualDriverClass = qDrvCls;
        try {
            Class.forName(this.qualDriverClass);
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not init SQLDriver", (Throwable)e);
        }
    }

    @Override
    public CachedRowSet sqlQuery(String queryString) {
        Statement statement = null;
        CachedRowSet rowSet = null;
        try {
            this.openConnection();
            statement = this.connect.createStatement();
            ResultSet resultSet = statement.executeQuery(queryString);
            rowSet = this.getCachedRowSet(resultSet);
            this.closeConnection();
        }
        catch (SQLException e) {
            logger.error("sqlQuery failed", (Throwable)e);
        }
        return rowSet;
    }

    @Override
    public void sqlUpdate(String updateString) {
        Statement statement = null;
        try {
            this.openConnection();
            statement = this.connect.createStatement();
            statement.executeUpdate(updateString);
            this.closeConnection();
        }
        catch (SQLException e) {
            logger.error("sqlUpdate failed", (Throwable)e);
        }
    }

    public void openConnection() {
        try {
            if (this.connect == null) {
                this.openDataSource();
                this.connect = this.ds.getConnection();
            }
        }
        catch (SQLException e) {
            logger.error("Failed to open sql driver connection", (Throwable)e);
        }
    }

    public void closeConnection() {
        try {
            if (this.connect != null) {
                this.connect.close();
                this.connect = null;
            }
        }
        catch (SQLException e) {
            logger.error("Failed to close sql driver connection", (Throwable)e);
        }
    }

    public Connection getConnection() {
        return this.connect;
    }

    public boolean hasOpenConnection() {
        return this.connect == null;
    }

    private void openDataSource() {
        if (this.ds == null) {
            this.ds = new HikariDataSource();
            this.ds.setJdbcUrl(this.queryPrefix + this.dbPath);
            this.ds.setUsername(this.userName);
            this.ds.setPassword(this.password);
            this.ds.setMaximumPoolSize(5);
        }
    }

    private CachedRowSet getCachedRowSet(ResultSet resultSet) throws SQLException {
        RowSetFactory factory = RowSetProvider.newFactory();
        CachedRowSet rowset = factory.createCachedRowSet();
        rowset.populate(resultSet);
        return rowset;
    }
}

