/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ApiModel(description="PersistentVolumeClaimCondition contails details about state of pvc")
public class V1PersistentVolumeClaimCondition {
    public static final String SERIALIZED_NAME_LAST_PROBE_TIME = "lastProbeTime";
    @SerializedName(value="lastProbeTime")
    private DateTime lastProbeTime;
    public static final String SERIALIZED_NAME_LAST_TRANSITION_TIME = "lastTransitionTime";
    @SerializedName(value="lastTransitionTime")
    private DateTime lastTransitionTime;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1PersistentVolumeClaimCondition lastProbeTime(DateTime lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last time we probed the condition.")
    public DateTime getLastProbeTime() {
        return this.lastProbeTime;
    }

    public void setLastProbeTime(DateTime lastProbeTime) {
        this.lastProbeTime = lastProbeTime;
    }

    public V1PersistentVolumeClaimCondition lastTransitionTime(DateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last time the condition transitioned from one status to another.")
    public DateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(DateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public V1PersistentVolumeClaimCondition message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable message indicating details about last transition.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public V1PersistentVolumeClaimCondition reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique, this should be a short, machine understandable string that gives the reason for condition's last transition. If it reports \"ResizeStarted\" that means the underlying persistent volume is being resized.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1PersistentVolumeClaimCondition status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public V1PersistentVolumeClaimCondition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimCondition v1PersistentVolumeClaimCondition = (V1PersistentVolumeClaimCondition)o;
        return Objects.equals(this.lastProbeTime, v1PersistentVolumeClaimCondition.lastProbeTime) && Objects.equals(this.lastTransitionTime, v1PersistentVolumeClaimCondition.lastTransitionTime) && Objects.equals(this.message, v1PersistentVolumeClaimCondition.message) && Objects.equals(this.reason, v1PersistentVolumeClaimCondition.reason) && Objects.equals(this.status, v1PersistentVolumeClaimCondition.status) && Objects.equals(this.type, v1PersistentVolumeClaimCondition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastProbeTime, this.lastTransitionTime, this.message, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimCondition {\n");
        sb.append("    lastProbeTime: ").append(this.toIndentedString(this.lastProbeTime)).append("\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

