/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.upgrade;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Transaction;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseCallable;
import org.apache.qpid.server.store.berkeleydb.upgrade.DatabaseRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseTemplate.class);
    private final Environment _environment;
    private final String _sourceDatabaseName;
    private final String _targetDatabaseName;
    private final Transaction _parentTransaction;

    public DatabaseTemplate(Environment environment, String sourceDatabaseName, Transaction transaction) {
        this(environment, sourceDatabaseName, null, transaction);
    }

    public DatabaseTemplate(Environment environment, String sourceDatabaseName, String targetDatabaseName, Transaction parentTransaction) {
        this._environment = environment;
        this._sourceDatabaseName = sourceDatabaseName;
        this._targetDatabaseName = targetDatabaseName;
        this._parentTransaction = parentTransaction;
    }

    public void run(DatabaseRunnable databaseRunnable) {
        DatabaseCallable<Void> callable = this.runnableToCallable(databaseRunnable);
        this.call(callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(DatabaseCallable<T> databaseCallable) {
        T t;
        Database sourceDatabase = null;
        Database targetDatabase = null;
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTransactional(true);
            dbConfig.setAllowCreate(true);
            sourceDatabase = this._environment.openDatabase(this._parentTransaction, this._sourceDatabaseName, dbConfig);
            if (this._targetDatabaseName != null) {
                targetDatabase = this._environment.openDatabase(this._parentTransaction, this._targetDatabaseName, dbConfig);
            }
            t = databaseCallable.call(sourceDatabase, targetDatabase, this._parentTransaction);
            this.closeDatabase(sourceDatabase);
            this.closeDatabase(targetDatabase);
        }
        catch (Throwable throwable) {
            this.closeDatabase(sourceDatabase);
            this.closeDatabase(targetDatabase);
            throw throwable;
        }
        return t;
    }

    private DatabaseCallable<Void> runnableToCallable(final DatabaseRunnable databaseRunnable) {
        return new DatabaseCallable<Void>(){

            @Override
            public Void call(Database sourceDatabase, Database targetDatabase, Transaction transaction) {
                databaseRunnable.run(sourceDatabase, targetDatabase, transaction);
                return null;
            }
        };
    }

    private void closeDatabase(Database database) {
        if (database != null) {
            try {
                database.close();
            }
            catch (Exception e) {
                LOGGER.error("Unable to close database", (Throwable)e);
            }
        }
    }
}

