/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.qpid.server.security.access.firewall.AbstractFirewallRuleImpl;
import org.apache.qpid.server.security.access.firewall.AccessControlFirewallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostnameFirewallRule
extends AbstractFirewallRuleImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostnameFirewallRule.class);
    private static final long DNS_TIMEOUT = 30000L;
    private static final ExecutorService DNS_LOOKUP = Executors.newCachedThreadPool();
    private final List<Pattern> _hostnamePatterns;
    private final Set<String> _hostnames;

    public HostnameFirewallRule(String ... hostnames) {
        this(Arrays.asList(hostnames));
    }

    public HostnameFirewallRule(Collection<String> hostnames) {
        this._hostnames = new HashSet<String>(hostnames);
        this._hostnamePatterns = new ArrayList<Pattern>(this._hostnames.size());
        for (String hostname : this._hostnames) {
            this._hostnamePatterns.add(Pattern.compile(hostname));
        }
        LOGGER.debug("Created {}", (Object)this);
    }

    @Override
    boolean matches(InetAddress remote) {
        String hostname = this.getHostname(remote);
        if (hostname == null) {
            throw new AccessControlFirewallException("DNS lookup failed for address " + remote);
        }
        for (Pattern pattern : this._hostnamePatterns) {
            if (!pattern.matcher(hostname).matches()) continue;
            LOGGER.debug("Hostname '{}' matches rule '{}'", (Object)hostname, (Object)pattern);
            return true;
        }
        LOGGER.debug("Hostname '{}' matches no configured hostname patterns", (Object)hostname);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHostname(InetAddress remote) {
        FutureTask<String> lookup = new FutureTask<String>(remote::getCanonicalHostName);
        DNS_LOOKUP.execute(lookup);
        try {
            String string = lookup.get(30000L, TimeUnit.MILLISECONDS);
            return string;
        }
        catch (InterruptedException | RuntimeException | ExecutionException | TimeoutException e) {
            LOGGER.warn(String.format("Unable to look up hostname from address '%s'", remote), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            lookup.cancel(true);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostnameFirewallRule that = (HostnameFirewallRule)o;
        return this._hostnames.equals(that._hostnames);
    }

    public int hashCode() {
        return this._hostnames.hashCode();
    }

    public String toString() {
        return "HostnameFirewallRule[hostnames=" + this._hostnames + "]";
    }
}

