/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt;

import de.iip_ecosphere.platform.deviceMgt.AasDeviceFirmwareOperations;
import de.iip_ecosphere.platform.deviceMgt.AasDeviceResourceConfigOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceFirmwareOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceManagement;
import de.iip_ecosphere.platform.deviceMgt.DeviceManagementImpl;
import de.iip_ecosphere.platform.deviceMgt.DeviceRemoteManagementOperations;
import de.iip_ecosphere.platform.deviceMgt.DeviceResourceConfigOperations;
import de.iip_ecosphere.platform.deviceMgt.ssh.SshRemoteManagementOperations;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.Optional;

public class DeviceManagementFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DeviceManagementFactory.class.getName());
    private static DeviceManagement management;
    private static DeviceRemoteManagementOperations remoteManagementOperations;
    private static DeviceFirmwareOperations firmwareOperations;
    private static DeviceResourceConfigOperations resourceConfigOperations;

    public static DeviceManagement getDeviceManagement() {
        if (null == management) {
            Optional first;
            if (null == firmwareOperations) {
                first = ServiceLoaderUtils.findFirst(DeviceFirmwareOperations.class);
                if (first.isPresent()) {
                    firmwareOperations = (DeviceFirmwareOperations)first.get();
                } else {
                    firmwareOperations = new AasDeviceFirmwareOperations();
                    LOGGER.warn("No DeviceFirmwareOperations implementation available, fall back to default implementation: Direct AAS Method");
                }
            }
            if (null == resourceConfigOperations) {
                first = ServiceLoaderUtils.findFirst(DeviceResourceConfigOperations.class);
                if (first.isPresent()) {
                    resourceConfigOperations = (DeviceResourceConfigOperations)first.get();
                } else {
                    resourceConfigOperations = new AasDeviceResourceConfigOperations();
                    LOGGER.warn("No DeviceResourceConfigOperations implementation available, fall back to default implementation: Direct AAS Method");
                }
            }
            if (null == remoteManagementOperations) {
                first = ServiceLoaderUtils.findFirst(DeviceRemoteManagementOperations.class);
                if (first.isPresent()) {
                    remoteManagementOperations = (DeviceRemoteManagementOperations)first.get();
                } else {
                    remoteManagementOperations = new SshRemoteManagementOperations();
                    LOGGER.warn("No DeviceRemoteManagementOperations implementation available, fall back to default implementation: SSHProxy.");
                }
            }
            management = new DeviceManagementImpl(firmwareOperations, remoteManagementOperations, resourceConfigOperations);
        }
        return management;
    }

    protected static void resetDeviceManagement() {
        management = null;
        firmwareOperations = null;
        remoteManagementOperations = null;
        resourceConfigOperations = null;
    }
}

