/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.ssh;

import de.iip_ecosphere.platform.deviceMgt.ssh.Proxy;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.net.Socket;

public class Connection
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final Socket clientSocket;
    private final String remoteIp;
    private final int remotePort;
    private Socket serverConnection = null;
    private Thread clientServerThread;
    private Thread serverClientThread;

    public Connection(Socket clientSocket, String remoteIp, int remotePort) {
        this.clientSocket = clientSocket;
        this.remoteIp = remoteIp;
        this.remotePort = remotePort;
    }

    @Override
    public void run() {
        LOGGER.info("new connection {}:{}", (Object)this.clientSocket.getInetAddress().getHostName(), (Object)this.clientSocket.getPort());
        try {
            this.serverConnection = new Socket(this.remoteIp, this.remotePort);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        LOGGER.info("Proxy {}:{} <-> {}:{}", new Object[]{this.clientSocket.getInetAddress().getHostName(), this.clientSocket.getPort(), this.serverConnection.getInetAddress().getHostName(), this.serverConnection.getPort()});
        this.clientServerThread = new Thread(new Proxy(this.clientSocket, this.serverConnection));
        this.clientServerThread.start();
        this.serverClientThread = new Thread(new Proxy(this.serverConnection, this.clientSocket));
        this.serverClientThread.start();
        while (true) {
            if (this.clientSocket.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                this.clientServerThread.interrupt();
                this.serverClientThread.interrupt();
            }
        }
        LOGGER.info("client socket ({}:{}) closed", (Object)this.clientSocket.getInetAddress().getHostName(), (Object)this.clientSocket.getPort());
        this.closeServerConnection();
    }

    private void closeServerConnection() {
        if (this.serverConnection != null && !this.serverConnection.isClosed()) {
            try {
                LOGGER.info("closing remote host connection {}:{}", (Object)this.serverConnection.getInetAddress().getHostName(), (Object)this.serverConnection.getPort());
                this.serverConnection.close();
                this.clientServerThread.interrupt();
                this.serverClientThread.interrupt();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

