/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;

public class BoneCPConnectionProvider
implements ConnectionProvider {
    public static final int DEFAULT_MIN_CONNECTIONS_PER_PARTITION = 5;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_PARTITION = 10;
    public static final int DEFAULT_PARTITION_COUNT = 4;
    private final BoneCP _connectionPool;

    public BoneCPConnectionProvider(String connectionUrl, String username, String password, Map<String, String> providerAttributes) throws SQLException {
        this._connectionPool = new BoneCP(BoneCPConnectionProvider.createBoneCPConfig(connectionUrl, username, password, providerAttributes));
    }

    static BoneCPConfig createBoneCPConfig(String connectionUrl, String username, String password, Map<String, String> providerAttributes) {
        BoneCPConfig config = new BoneCPConfig();
        config.setJdbcUrl(connectionUrl);
        if (username != null) {
            config.setUsername(username);
            config.setPassword(password);
        }
        HashMap<String, String> attributes = new HashMap<String, String>(providerAttributes);
        attributes.putIfAbsent("qpid.jdbcstore.bonecp.minConnectionsPerPartition", String.valueOf(5));
        attributes.putIfAbsent("qpid.jdbcstore.bonecp.maxConnectionsPerPartition", String.valueOf(10));
        attributes.putIfAbsent("qpid.jdbcstore.bonecp.partitionCount", String.valueOf(4));
        Map<String, String> propertiesMap = attributes.entrySet().stream().collect(Collectors.toMap(p -> ((String)p.getKey()).substring("qpid.jdbcstore.".length()), Map.Entry::getValue));
        Properties properties = new Properties();
        properties.putAll(propertiesMap);
        try {
            config.setProperties(properties);
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Unexpected exception on applying BoneCP configuration", (Throwable)e);
        }
        return config;
    }

    public Connection getConnection() throws SQLException {
        return this._connectionPool.getConnection();
    }

    public void close() throws SQLException {
        this._connectionPool.shutdown();
    }
}

