/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.configuration.updater.Task;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.BrokerImpl;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.SystemConfig;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.auth.SocketConnectionMetaData;
import org.apache.qpid.server.util.FixedKeyMapCreator;

final class BrokerImplWithAccessChecking
extends BrokerImpl {
    private static final FixedKeyMapCreator EXTRACT_CONFIG_MAP_CREATOR = new FixedKeyMapCreator("includeSecureAttributes");
    private static final FixedKeyMapCreator GET_THREAD_STACK_TRACES_MAP_CREATOR = new FixedKeyMapCreator("appendToLog");
    private static final FixedKeyMapCreator FIND_THREAD_STACK_TRACES_MAP_CREATOR = new FixedKeyMapCreator("threadNameFindExpression");
    private static final FixedKeyMapCreator PURGE_USER_MAP_CREATOR = new FixedKeyMapCreator("origin", "username");

    BrokerImplWithAccessChecking(Map<String, Object> attributes, SystemConfig systemconfig) {
        super(attributes, systemconfig);
    }

    @Override
    public Map<String, Object> getStatistics(List<String> statistics) {
        return super.getStatistics(statistics);
    }

    @Override
    public String setContextVariable(final String name, final String value) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BrokerImplWithAccessChecking.super.setContextVariable(name, value));
            }

            @Override
            public String getObject() {
                return BrokerImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "setContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name + ",value=" + value;
                }
                return this._args;
            }
        }));
    }

    @Override
    public String removeContextVariable(final String name) {
        return this.doSync(this.doOnConfigThread(new Task<ListenableFuture<String>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<String> execute() {
                return Futures.immediateFuture((Object)BrokerImplWithAccessChecking.super.removeContextVariable(name));
            }

            @Override
            public String getObject() {
                return BrokerImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "removeContextVariable";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "name=" + name;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.INVOKE_METHOD("resetStatistics"));
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                BrokerImplWithAccessChecking.super.resetStatistics();
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return BrokerImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "resetStatistics";
            }

            @Override
            public String getArguments() {
                return this._args;
            }
        }));
    }

    @Override
    public void initiateShutdown() {
        this.authorise(Operation.INVOKE_METHOD("initiateShutdown"));
        super.initiateShutdown();
    }

    @Override
    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        this.authorise(Operation.INVOKE_METHOD("extractConfig"), EXTRACT_CONFIG_MAP_CREATOR.createMap(includeSecureAttributes));
        return super.extractConfig(includeSecureAttributes);
    }

    @Override
    public void restart() {
        this.authorise(Operation.INVOKE_METHOD("restart"));
        this.logOperation("restart");
        super.restart();
    }

    @Override
    public void performGC() {
        this.authorise(Operation.INVOKE_METHOD("performGC"));
        super.performGC();
    }

    @Override
    public Content getThreadStackTraces(boolean appendToLog) {
        this.authorise(Operation.INVOKE_METHOD("getThreadStackTraces"), GET_THREAD_STACK_TRACES_MAP_CREATOR.createMap(appendToLog));
        return super.getThreadStackTraces(appendToLog);
    }

    @Override
    public Content findThreadStackTraces(String threadNameFindExpression) {
        this.authorise(Operation.INVOKE_METHOD("findThreadStackTraces"), FIND_THREAD_STACK_TRACES_MAP_CREATOR.createMap(threadNameFindExpression));
        return super.findThreadStackTraces(threadNameFindExpression);
    }

    @Override
    public Principal getUser() {
        return super.getUser();
    }

    @Override
    public SocketConnectionMetaData getConnectionMetaData() {
        return super.getConnectionMetaData();
    }

    @Override
    public Set<Principal> getGroups() {
        return super.getGroups();
    }

    @Override
    public void purgeUser(final AuthenticationProvider<?> origin, final String username) {
        this.authorise(Operation.INVOKE_METHOD("purgeUser"), PURGE_USER_MAP_CREATOR.createMap(origin, username));
        this.doSync(this.doOnConfigThread(new Task<ListenableFuture<Void>, RuntimeException>(){
            private String _args;

            @Override
            public ListenableFuture<Void> execute() {
                BrokerImplWithAccessChecking.super.purgeUser(origin, username);
                return Futures.immediateFuture(null);
            }

            @Override
            public String getObject() {
                return BrokerImplWithAccessChecking.this.toString();
            }

            @Override
            public String getAction() {
                return "purgeUser";
            }

            @Override
            public String getArguments() {
                if (this._args == null) {
                    this._args = "origin=" + origin + ",username=" + username;
                }
                return this._args;
            }
        }));
    }

    @Override
    public void compactMemory() {
        this.authorise(Operation.INVOKE_METHOD("compactMemory"));
        super.compactMemory();
    }
}

