/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectMethodAttribute;
import org.apache.qpid.server.model.ConfiguredSettableAttribute;
import org.apache.qpid.server.model.Initialization;
import org.apache.qpid.server.model.ManagedAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfiguredAutomatedAttribute<C extends ConfiguredObject, T>
extends ConfiguredObjectMethodAttribute<C, T>
implements ConfiguredSettableAttribute<C, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredAutomatedAttribute.class);
    private final ManagedAttribute _annotation;
    private final Method _validValuesMethod;
    private final Pattern _secureValuePattern;
    private final AttributeValueConverter<T> _converter;

    ConfiguredAutomatedAttribute(Class<C> clazz, Method getter, ManagedAttribute annotation) {
        super(clazz, getter);
        this._converter = AttributeValueConverter.getConverter(this.getType(), getter.getGenericReturnType());
        this._annotation = annotation;
        Method validValuesMethod = null;
        if (this._annotation.validValues().length == 1) {
            String validValue = this._annotation.validValues()[0];
            validValuesMethod = this.getValidValuesMethod(validValue, clazz);
        }
        this._validValuesMethod = validValuesMethod;
        String secureValueFilter = this._annotation.secureValueFilter();
        this._secureValuePattern = secureValueFilter == null || "".equals(secureValueFilter) ? null : Pattern.compile(secureValueFilter);
    }

    @Override
    public final AttributeValueConverter<T> getConverter() {
        return this._converter;
    }

    private Method getValidValuesMethod(String validValue, Class<C> clazz) {
        if (validValue.matches("([\\w][\\w\\d_]+\\.)+[\\w][\\w\\d_\\$]*#[\\w\\d_]+\\s*\\(\\s*\\)")) {
            String function = validValue;
            try {
                Type parameterizedType;
                String className = function.split("#")[0].trim();
                String methodName = function.split("#")[1].split("\\(")[0].trim();
                Class<?> validValueCalculatingClass = Class.forName(className);
                Method method = validValueCalculatingClass.getMethod(methodName, new Class[0]);
                if (Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && Collection.class.isAssignableFrom(method.getReturnType()) && method.getGenericReturnType() instanceof ParameterizedType && (parameterizedType = ((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]) == String.class) {
                    return method;
                }
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOGGER.warn("The validValues of the " + this.getName() + " attribute in class " + clazz.getSimpleName() + " has value '" + validValue + "' which looks like it should be a method, but no such method could be used.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isAutomated() {
        return true;
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    @Override
    public String defaultValue() {
        return this._annotation.defaultValue();
    }

    @Override
    public boolean isSecure() {
        return this._annotation.secure();
    }

    @Override
    public boolean isMandatory() {
        return this._annotation.mandatory();
    }

    @Override
    public boolean isImmutable() {
        return this._annotation.immutable();
    }

    @Override
    public boolean isPersisted() {
        return this._annotation.persist();
    }

    @Override
    public boolean isOversized() {
        return this._annotation.oversize();
    }

    @Override
    public boolean updateAttributeDespiteUnchangedValue() {
        return this._annotation.updateAttributeDespiteUnchangedValue();
    }

    @Override
    public String getOversizedAltText() {
        return this._annotation.oversizedAltText();
    }

    @Override
    public Initialization getInitialization() {
        return this._annotation.initialization();
    }

    @Override
    public String getDescription() {
        return this._annotation.description();
    }

    @Override
    public Pattern getSecureValueFilter() {
        return this._secureValuePattern;
    }

    @Override
    public Collection<String> validValues() {
        if (this._validValuesMethod != null) {
            try {
                return (Collection)this._validValuesMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("Could not execute the validValues generation method " + this._validValuesMethod.getName(), (Throwable)e);
                return Collections.emptySet();
            }
        }
        if (this._annotation.validValues().length == 0 && this.getGetter().getReturnType().isEnum()) {
            Enum[] constants = (Enum[])this.getGetter().getReturnType().getEnumConstants();
            ArrayList<String> validValues = new ArrayList<String>(constants.length);
            for (Enum constant : constants) {
                validValues.add(constant.name());
            }
            return validValues;
        }
        return Arrays.asList(this._annotation.validValues());
    }

    @Override
    public boolean hasValidValues() {
        return this.validValues() != null && this.validValues().size() > 0;
    }

    @Override
    public String validValuePattern() {
        return this._annotation.validValuePattern();
    }

    @Override
    public T convert(Object value, C object) {
        AttributeValueConverter<T> converter = this.getConverter();
        try {
            return converter.convert(value, (ConfiguredObject)object);
        }
        catch (IllegalArgumentException iae) {
            Type returnType = this.getGetter().getGenericReturnType();
            String simpleName = returnType instanceof Class ? ((Class)returnType).getSimpleName() : returnType.toString();
            throw new IllegalArgumentException("Cannot convert '" + (this.isSecure() ? "********" : value) + "' into a " + simpleName + " for attribute " + this.getName() + " (" + iae.getMessage() + ")", iae);
        }
    }
}

