/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import com.google.common.base.Supplier;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.Subject;
import javax.security.auth.SubjectDomainCombiner;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.configuration.updater.TaskExecutor;
import org.apache.qpid.server.connection.ConnectionPrincipal;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.EventLoggerProvider;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.logging.subjects.ConnectionLogSubject;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ContextProvider;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Session;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.TaskExecutorProvider;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.sasl.SaslSettings;
import org.apache.qpid.server.session.AbstractAMQPSession;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.transport.AMQPConnection;
import org.apache.qpid.server.transport.AggregateTicker;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.transport.NonBlockingConnection;
import org.apache.qpid.server.transport.ProtocolEngine;
import org.apache.qpid.server.transport.SchedulingDelayNotificationListener;
import org.apache.qpid.server.transport.ServerIdleReadTimeoutTicker;
import org.apache.qpid.server.transport.ServerIdleWriteTimeoutTicker;
import org.apache.qpid.server.transport.ServerNetworkConnection;
import org.apache.qpid.server.transport.TransactionTimeoutTicker;
import org.apache.qpid.server.transport.network.NetworkConnection;
import org.apache.qpid.server.transport.network.Ticker;
import org.apache.qpid.server.txn.FlowToDiskTransactionObserver;
import org.apache.qpid.server.txn.LocalTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.TransactionObserver;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAMQPConnection<C extends AbstractAMQPConnection<C, T>, T>
extends AbstractConfiguredObject<C>
implements ProtocolEngine,
AMQPConnection<C>,
EventLoggerProvider,
SaslSettings {
    public static final FixedKeyMapCreator PUBLISH_ACTION_MAP_CREATOR = new FixedKeyMapCreator("routingKey", "immediate");
    private static final String OPEN_TRANSACTION_TIMEOUT_ERROR = "Open transaction timed out";
    private static final String IDLE_TRANSACTION_TIMEOUT_ERROR = "Idle transaction timed out";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAMQPConnection.class);
    private final Broker<?> _broker;
    private final ServerNetworkConnection _network;
    private final AmqpPort<?> _port;
    private final Transport _transport;
    private final Protocol _protocol;
    private final long _connectionId;
    private final AggregateTicker _aggregateTicker;
    private final Subject _subject = new Subject();
    private final List<Action<? super C>> _connectionCloseTaskList = new CopyOnWriteArrayList<Action<? super C>>();
    private final LogSubject _logSubject;
    private volatile ContextProvider _contextProvider;
    private volatile EventLoggerProvider _eventLoggerProvider;
    private String _clientProduct;
    private String _clientVersion;
    private String _remoteProcessPid;
    private String _clientId;
    private volatile boolean _stopped;
    private final AtomicLong _messagesIn = new AtomicLong();
    private final AtomicLong _messagesOut = new AtomicLong();
    private final AtomicLong _transactedMessagesIn = new AtomicLong();
    private final AtomicLong _transactedMessagesOut = new AtomicLong();
    private final AtomicLong _bytesIn = new AtomicLong();
    private final AtomicLong _bytesOut = new AtomicLong();
    private final AtomicLong _localTransactionBegins = new AtomicLong();
    private final AtomicLong _localTransactionRollbacks = new AtomicLong();
    private final AtomicLong _localTransactionOpens = new AtomicLong();
    private final SettableFuture<Void> _transportClosedFuture = SettableFuture.create();
    private final SettableFuture<Void> _modelTransportRendezvousFuture = SettableFuture.create();
    private volatile NamedAddressSpace _addressSpace;
    private volatile long _lastReadTime;
    private volatile long _lastWriteTime;
    private volatile long _lastMessageInboundTime;
    private volatile long _lastMessageOutboundTime;
    private volatile boolean _messagesWritten;
    private volatile AccessControlContext _accessControllerContext;
    private volatile Thread _ioThread;
    private volatile StatisticsGatherer _statisticsGatherer;
    private volatile boolean _messageAuthorizationRequired;
    private final AtomicLong _maxMessageSize = new AtomicLong(Integer.MAX_VALUE);
    private volatile int _messageCompressionThreshold;
    private volatile TransactionObserver _transactionObserver;
    private long _maxUncommittedInMemorySize;
    private final Map<ServerTransaction, Set<Ticker>> _transactionTickers = new ConcurrentHashMap<ServerTransaction, Set<Ticker>>();

    public AbstractAMQPConnection(Broker<?> broker, ServerNetworkConnection network, AmqpPort<?> port, Transport transport, Protocol protocol, long connectionId, AggregateTicker aggregateTicker) {
        super(port, AbstractAMQPConnection.createAttributes(connectionId, network));
        this._broker = broker;
        this._eventLoggerProvider = broker;
        this._contextProvider = broker;
        this._statisticsGatherer = broker;
        this._network = network;
        this._port = port;
        this._transport = transport;
        this._protocol = protocol;
        this._connectionId = connectionId;
        this._aggregateTicker = aggregateTicker;
        this._subject.getPrincipals().add(new ConnectionPrincipal(this));
        this.updateAccessControllerContext();
        this._transportClosedFuture.addListener(() -> {
            this._modelTransportRendezvousFuture.set(null);
            this.doAfter(this.closeAsync(), this::logConnectionClose);
        }, (Executor)this.getTaskExecutor());
        this.setState(State.ACTIVE);
        this._logSubject = new ConnectionLogSubject(this);
    }

    private static Map<String, Object> createAttributes(long connectionId, NetworkConnection network) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("name", "[" + connectionId + "] " + String.valueOf(network.getRemoteAddress()).replaceAll("/", ""));
        attributes.put("durable", false);
        return attributes;
    }

    @Override
    public final AccessControlContext getAccessControlContextFromSubject(Subject subject) {
        AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(() -> {
            if (subject == null) {
                return new AccessControlContext(acc, null);
            }
            return new AccessControlContext(acc, new SubjectDomainCombiner(subject));
        });
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        long maxAuthDelay = this._port.getContextValue(Long.class, "connection.maximumAuthenticationDelay");
        SlowConnectionOpenTicker slowConnectionOpenTicker = new SlowConnectionOpenTicker(maxAuthDelay);
        this._aggregateTicker.addTicker(slowConnectionOpenTicker);
        this._lastMessageInboundTime = this._lastMessageOutboundTime = this.getCreatedTime().getTime();
        this._lastWriteTime = this._lastMessageOutboundTime;
        this._lastReadTime = this._lastMessageOutboundTime;
        this._maxUncommittedInMemorySize = this.getContextValue(Long.class, "connection.maxUncommittedInMemorySize");
        this._transactionObserver = this._maxUncommittedInMemorySize < 0L ? FlowToDiskTransactionObserver.NOOP_TRANSACTION_OBSERVER : new FlowToDiskTransactionObserver(this._maxUncommittedInMemorySize, this._logSubject, this._eventLoggerProvider.getEventLogger());
    }

    @Override
    public Broker<?> getBroker() {
        return this._broker;
    }

    public final ServerNetworkConnection getNetwork() {
        return this._network;
    }

    @Override
    public final AmqpPort<?> getPort() {
        return this._port;
    }

    @Override
    public final Transport getTransport() {
        return this._transport;
    }

    @Override
    public String getTransportInfo() {
        return this._network.getTransportInfo();
    }

    @Override
    public Protocol getProtocol() {
        return this._protocol;
    }

    @Override
    public AggregateTicker getAggregateTicker() {
        return this._aggregateTicker;
    }

    @Override
    public final Date getLastIoTime() {
        return new Date(Math.max(this.getLastReadTime(), this.getLastWriteTime()));
    }

    @Override
    public final long getLastReadTime() {
        return this._lastReadTime;
    }

    private void updateLastReadTime() {
        this._lastReadTime = System.currentTimeMillis();
    }

    @Override
    public final long getLastWriteTime() {
        return this._lastWriteTime;
    }

    public final void updateLastWriteTime() {
        long currentTime;
        this._lastWriteTime = currentTime = System.currentTimeMillis();
        if (this._messagesWritten) {
            this._messagesWritten = false;
            this._lastMessageOutboundTime = currentTime;
        }
    }

    @Override
    public void updateLastMessageInboundTime() {
        this._lastMessageInboundTime = this._lastReadTime;
    }

    @Override
    public void updateLastMessageOutboundTime() {
        this._messagesWritten = true;
    }

    @Override
    public Date getLastInboundMessageTime() {
        return new Date(this._lastMessageInboundTime);
    }

    @Override
    public Date getLastOutboundMessageTime() {
        return new Date(this._lastMessageOutboundTime);
    }

    @Override
    public Date getLastMessageTime() {
        return new Date(Math.max(this._lastMessageInboundTime, this._lastMessageOutboundTime));
    }

    @Override
    public final long getConnectionId() {
        return this._connectionId;
    }

    @Override
    public String getRemoteAddressString() {
        return String.valueOf(this._network.getRemoteAddress());
    }

    @Override
    public final void stopConnection() {
        this._stopped = true;
    }

    @Override
    public boolean isConnectionStopped() {
        return this._stopped;
    }

    @Override
    public final String getAddressSpaceName() {
        return this.getAddressSpace() == null ? null : this.getAddressSpace().getName();
    }

    @Override
    public String getClientVersion() {
        return this._clientVersion;
    }

    @Override
    public String getRemoteProcessPid() {
        return this._remoteProcessPid;
    }

    @Override
    public void pushScheduler(NetworkConnectionScheduler networkConnectionScheduler) {
        if (this._network instanceof NonBlockingConnection) {
            ((NonBlockingConnection)this._network).pushScheduler(networkConnectionScheduler);
        }
    }

    @Override
    public NetworkConnectionScheduler popScheduler() {
        if (this._network instanceof NonBlockingConnection) {
            return ((NonBlockingConnection)this._network).popScheduler();
        }
        return null;
    }

    @Override
    public String getClientProduct() {
        return this._clientProduct;
    }

    protected void updateMaxMessageSize() {
        this._maxMessageSize.set(Math.min(this.getMaxMessageSize(this.getPort()), this.getMaxMessageSize(this._contextProvider)));
    }

    private long getMaxMessageSize(ContextProvider object) {
        try {
            int maxMessageSize = object.getContextValue(Integer.class, "qpid.max_message_size");
            return maxMessageSize > 0 ? (long)maxMessageSize : Integer.MAX_VALUE;
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOGGER.warn("Context variable {} has invalid value and cannot be used to restrict maximum message size", (Object)"qpid.max_message_size", (Object)e);
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public long getMaxMessageSize() {
        return this._maxMessageSize.get();
    }

    @Override
    public void addDeleteTask(Action<? super C> task) {
        this._connectionCloseTaskList.add(task);
    }

    @Override
    public void removeDeleteTask(Action<? super C> task) {
        this._connectionCloseTaskList.remove(task);
    }

    public void performDeleteTasks() {
        if (this.runningAsSubject()) {
            for (Action<C> task : this._connectionCloseTaskList) {
                task.performAction(this);
            }
        } else {
            this.runAsSubject(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    AbstractAMQPConnection.this.performDeleteTasks();
                    return null;
                }
            });
        }
    }

    @Override
    public String getClientId() {
        return this._clientId;
    }

    @Override
    public final SocketAddress getRemoteSocketAddress() {
        return this._network.getRemoteAddress();
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesOut.incrementAndGet();
        this._bytesOut.addAndGet(messageSize);
        this._statisticsGatherer.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize) {
        this.updateLastMessageInboundTime();
        this._messagesIn.incrementAndGet();
        this._bytesIn.addAndGet(messageSize);
        this._statisticsGatherer.registerMessageReceived(messageSize);
    }

    @Override
    public void registerTransactedMessageDelivered() {
        this._transactedMessagesOut.incrementAndGet();
        this._statisticsGatherer.registerTransactedMessageDelivered();
    }

    @Override
    public void registerTransactedMessageReceived() {
        this._transactedMessagesIn.incrementAndGet();
        this._statisticsGatherer.registerTransactedMessageReceived();
    }

    public void setClientProduct(String clientProduct) {
        this._clientProduct = clientProduct;
    }

    public void setClientVersion(String clientVersion) {
        this._clientVersion = clientVersion;
    }

    public void setRemoteProcessPid(String remoteProcessPid) {
        this._remoteProcessPid = remoteProcessPid;
    }

    public void setClientId(String clientId) {
        this._clientId = clientId;
    }

    @Override
    public void setIOThread(Thread ioThread) {
        this._ioThread = ioThread;
    }

    @Override
    public boolean isIOThread() {
        return Thread.currentThread() == this._ioThread;
    }

    @Override
    public ListenableFuture<Void> doOnIOThreadAsync(final Runnable task) {
        if (this.isIOThread()) {
            task.run();
            return Futures.immediateFuture(null);
        }
        final SettableFuture future = SettableFuture.create();
        this.addAsyncTask(new Action<Object>(){

            @Override
            public void performAction(Object object) {
                try {
                    task.run();
                    future.set(null);
                }
                catch (RuntimeException e) {
                    future.setException((Throwable)e);
                }
            }
        });
        return future;
    }

    @Override
    public final void received(QpidByteBuffer buf) {
        AccessController.doPrivileged(() -> {
            this.updateLastReadTime();
            try {
                this.onReceive(buf);
            }
            catch (StoreException e) {
                if (this.getAddressSpace().isActive()) {
                    throw new ServerScopedRuntimeException(e);
                }
                throw new ConnectionScopedRuntimeException(e);
            }
            return null;
        }, this.getAccessControllerContext());
    }

    protected abstract void onReceive(QpidByteBuffer var1);

    protected abstract void addAsyncTask(Action<? super T> var1);

    protected abstract boolean isOpeningInProgress();

    protected <T> T runAsSubject(PrivilegedAction<T> action) {
        return Subject.doAs(this._subject, action);
    }

    private boolean runningAsSubject() {
        return this._subject.equals(Subject.getSubject(AccessController.getContext()));
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    @Override
    public TaskExecutor getChildExecutor() {
        NamedAddressSpace addressSpace = this.getAddressSpace();
        if (addressSpace instanceof TaskExecutorProvider) {
            return ((TaskExecutorProvider)((Object)addressSpace)).getTaskExecutor();
        }
        return super.getChildExecutor();
    }

    @Override
    public boolean isIncoming() {
        return true;
    }

    @Override
    public String getLocalAddress() {
        return null;
    }

    @Override
    public String getPrincipal() {
        Principal authorizedPrincipal = this.getAuthorizedPrincipal();
        return authorizedPrincipal == null ? null : authorizedPrincipal.getName();
    }

    @Override
    public String getRemoteAddress() {
        return this.getRemoteAddressString();
    }

    @Override
    public String getRemoteProcessName() {
        return null;
    }

    @Override
    public Collection<Session> getSessions() {
        return this.getChildren(Session.class);
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        return this.closeAsyncIfNotAlreadyClosing();
    }

    @Override
    protected ListenableFuture<Void> beforeClose() {
        return this.closeAsyncIfNotAlreadyClosing();
    }

    @Override
    protected ListenableFuture<Void> onClose() {
        if (this._transactionObserver != null) {
            this._transactionObserver.reset();
        }
        return Futures.immediateFuture(null);
    }

    private ListenableFuture<Void> closeAsyncIfNotAlreadyClosing() {
        if (!this._modelTransportRendezvousFuture.isDone()) {
            this.sendConnectionCloseAsync(AMQPConnection.CloseReason.MANAGEMENT, "Connection closed by external action");
        }
        return this._modelTransportRendezvousFuture;
    }

    @Override
    protected <C extends ConfiguredObject> ListenableFuture<C> addChildAsync(Class<C> childClass, Map<String, Object> attributes) {
        if (childClass == Session.class) {
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException("Cannot create a child of class " + childClass.getSimpleName());
    }

    @Override
    public long getBytesIn() {
        return this._bytesIn.get();
    }

    @Override
    public long getBytesOut() {
        return this._bytesOut.get();
    }

    @Override
    public long getMessagesIn() {
        return this._messagesIn.get();
    }

    @Override
    public long getMessagesOut() {
        return this._messagesOut.get();
    }

    @Override
    public long getTransactedMessagesIn() {
        return this._transactedMessagesIn.get();
    }

    @Override
    public long getTransactedMessagesOut() {
        return this._transactedMessagesOut.get();
    }

    @Override
    public void resetStatistics() {
        this._lastMessageInboundTime = System.currentTimeMillis();
        this._lastMessageOutboundTime = System.currentTimeMillis();
        this._bytesIn.set(0L);
        this._bytesOut.set(0L);
        this._messagesIn.set(0L);
        this._messagesOut.set(0L);
        this._transactedMessagesIn.set(0L);
        this._transactedMessagesOut.set(0L);
        this._localTransactionBegins.set(0L);
        this._localTransactionRollbacks.set(0L);
        this.getChildren(Session.class).stream().filter(AbstractAMQPSession.class::isInstance).map(session -> (AbstractAMQPSession)session).forEach(AbstractAMQPSession::resetStatistics);
    }

    public AccessControlContext getAccessControllerContext() {
        return this._accessControllerContext;
    }

    public final void updateAccessControllerContext() {
        this._accessControllerContext = this.getAccessControlContextFromSubject(this.getSubject());
    }

    private void logConnectionOpen() {
        this.runAsSubject(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object localAddressStr;
                SocketAddress localAddress = AbstractAMQPConnection.this._network.getLocalAddress();
                if (localAddress instanceof InetSocketAddress) {
                    InetSocketAddress inetAddress = (InetSocketAddress)localAddress;
                    localAddressStr = inetAddress.getAddress().getHostAddress() + ":" + inetAddress.getPort();
                } else {
                    localAddressStr = localAddress.toString();
                }
                AbstractAMQPConnection.this.getEventLogger().message(ConnectionMessages.OPEN(AbstractAMQPConnection.this.getPort().getName(), (String)localAddressStr, AbstractAMQPConnection.this.getProtocol().getProtocolVersion(), AbstractAMQPConnection.this.getClientId(), AbstractAMQPConnection.this.getClientVersion(), AbstractAMQPConnection.this.getClientProduct(), AbstractAMQPConnection.this.getTransport().isSecure(), AbstractAMQPConnection.this.getClientId() != null, AbstractAMQPConnection.this.getClientVersion() != null, AbstractAMQPConnection.this.getClientProduct() != null));
                return null;
            }
        });
    }

    private void logConnectionClose() {
        this.runAsSubject(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String closeCause = AbstractAMQPConnection.this.getCloseCause();
                AbstractAMQPConnection.this.getEventLogger().message(AbstractAMQPConnection.this.isOrderlyClose() ? ConnectionMessages.CLOSE(closeCause, closeCause != null) : ConnectionMessages.DROPPED_CONNECTION());
                return null;
            }
        });
    }

    protected void initialiseHeartbeating(long writerDelay, long readerDelay) {
        if (writerDelay > 0L) {
            this._aggregateTicker.addTicker(new ServerIdleWriteTimeoutTicker(this, (int)writerDelay));
            this._network.setMaxWriteIdleMillis(writerDelay);
        }
        if (readerDelay > 0L) {
            this._aggregateTicker.addTicker(new ServerIdleReadTimeoutTicker(this._network, this, (int)readerDelay));
            this._network.setMaxReadIdleMillis(readerDelay);
        }
    }

    protected abstract boolean isOrderlyClose();

    protected abstract String getCloseCause();

    @Override
    public int getSessionCount() {
        return this.getSessionModels().size();
    }

    protected void markTransportClosed() {
        this._transportClosedFuture.set(null);
    }

    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    @Override
    public EventLogger getEventLogger() {
        return this._eventLoggerProvider.getEventLogger();
    }

    @Override
    public final void checkAuthorizedMessagePrincipal(String userId) {
        if (userId != null && !"".equals(userId.trim()) && this._messageAuthorizationRequired && !this.getAuthorizedPrincipal().getName().equals(userId)) {
            throw new AccessControlException("The user id of the message '" + userId + "' is not valid on a connection authenticated as  " + this.getAuthorizedPrincipal().getName());
        }
    }

    @Override
    public NamedAddressSpace getAddressSpace() {
        return this._addressSpace;
    }

    public ContextProvider getContextProvider() {
        return this._contextProvider;
    }

    public void setAddressSpace(NamedAddressSpace addressSpace) {
        this._addressSpace = addressSpace;
        if (addressSpace instanceof EventLoggerProvider) {
            this._eventLoggerProvider = (EventLoggerProvider)((Object)addressSpace);
        }
        if (addressSpace instanceof ContextProvider) {
            this._contextProvider = (ContextProvider)((Object)addressSpace);
        }
        if (addressSpace instanceof StatisticsGatherer) {
            this._statisticsGatherer = (StatisticsGatherer)((Object)addressSpace);
        }
        this.updateMaxMessageSize();
        this._messageAuthorizationRequired = this._contextProvider.getContextValue(Boolean.class, "qpid.broker_msg_auth");
        this._messageCompressionThreshold = this._contextProvider.getContextValue(Integer.class, "connection.messageCompressionThresholdSize");
        if (this._messageCompressionThreshold <= 0) {
            this._messageCompressionThreshold = Integer.MAX_VALUE;
        }
        this.getSubject().getPrincipals().add(addressSpace.getPrincipal());
        this.updateAccessControllerContext();
        this.logConnectionOpen();
    }

    @Override
    public int getMessageCompressionThreshold() {
        return this._messageCompressionThreshold;
    }

    @Override
    public long getMaxUncommittedInMemorySize() {
        return this._maxUncommittedInMemorySize;
    }

    @Override
    public String toString() {
        return this.getNetwork().getRemoteAddress() + "(" + (this.getAuthorizedPrincipal() == null ? "?" : this.getAuthorizedPrincipal().getName()) + ")";
    }

    @Override
    public Principal getAuthorizedPrincipal() {
        return AuthenticatedPrincipal.getOptionalAuthenticatedPrincipalFromSubject(this.getSubject());
    }

    public void setSubject(Subject subject) {
        if (subject == null) {
            throw new IllegalArgumentException("subject cannot be null");
        }
        this.getSubject().getPrincipals().addAll(subject.getPrincipals());
        this.getSubject().getPrivateCredentials().addAll(subject.getPrivateCredentials());
        this.getSubject().getPublicCredentials().addAll(subject.getPublicCredentials());
        this.updateAccessControllerContext();
    }

    @Override
    public LocalTransaction createLocalTransaction() {
        this._localTransactionBegins.incrementAndGet();
        this._localTransactionOpens.incrementAndGet();
        return new LocalTransaction(this.getAddressSpace().getMessageStore(), () -> this.getLastReadTime(), this._transactionObserver, this.getProtocol() != Protocol.AMQP_1_0);
    }

    @Override
    public void registerTransactionTickers(ServerTransaction serverTransaction, Action<String> closeAction, long notificationRepeatPeriod) {
        NamedAddressSpace addressSpace = this.getAddressSpace();
        if (addressSpace instanceof QueueManagingVirtualHost) {
            QueueManagingVirtualHost virtualhost = (QueueManagingVirtualHost)addressSpace;
            EventLogger eventLogger = virtualhost.getEventLogger();
            LinkedHashSet<TransactionTimeoutTicker> tickers = new LinkedHashSet<TransactionTimeoutTicker>(4);
            if (virtualhost.getStoreTransactionOpenTimeoutWarn() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionOpenTimeoutWarn(), notificationRepeatPeriod, (Supplier<Long>)((Supplier)serverTransaction::getTransactionStartTime), age -> eventLogger.message(this.getLogSubject(), ConnectionMessages.OPEN_TXN(age))));
            }
            if (virtualhost.getStoreTransactionOpenTimeoutClose() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionOpenTimeoutClose(), notificationRepeatPeriod, (Supplier<Long>)((Supplier)serverTransaction::getTransactionStartTime), age -> closeAction.performAction(OPEN_TRANSACTION_TIMEOUT_ERROR)));
            }
            if (virtualhost.getStoreTransactionIdleTimeoutWarn() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionIdleTimeoutWarn(), notificationRepeatPeriod, (Supplier<Long>)((Supplier)serverTransaction::getTransactionUpdateTime), age -> eventLogger.message(this.getLogSubject(), ConnectionMessages.IDLE_TXN(age))));
            }
            if (virtualhost.getStoreTransactionIdleTimeoutClose() > 0L) {
                tickers.add(new TransactionTimeoutTicker(virtualhost.getStoreTransactionIdleTimeoutClose(), notificationRepeatPeriod, (Supplier<Long>)((Supplier)serverTransaction::getTransactionUpdateTime), age -> closeAction.performAction(IDLE_TRANSACTION_TIMEOUT_ERROR)));
            }
            if (!tickers.isEmpty()) {
                for (Ticker ticker : tickers) {
                    this.getAggregateTicker().addTicker(ticker);
                }
                this.notifyWork();
            }
            this._transactionTickers.put(serverTransaction, tickers);
        }
    }

    @Override
    public void unregisterTransactionTickers(ServerTransaction serverTransaction) {
        NamedAddressSpace addressSpace = this.getAddressSpace();
        if (addressSpace instanceof QueueManagingVirtualHost) {
            this._transactionTickers.remove(serverTransaction).forEach(t -> this.getAggregateTicker().removeTicker((Ticker)t));
        }
    }

    @Override
    protected void logOperation(String operation) {
        this.getEventLogger().message(ConnectionMessages.OPERATION(operation));
    }

    @Override
    public String getLocalFQDN() {
        SocketAddress address = this.getNetwork().getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostName();
        }
        throw new IllegalArgumentException("Unsupported socket address class: " + address);
    }

    @Override
    public Principal getExternalPrincipal() {
        return this.getNetwork().getPeerPrincipal();
    }

    @Override
    public Date getOldestTransactionStartTime() {
        long oldest = Long.MAX_VALUE;
        Iterator<ServerTransaction> iterator = this.getOpenTransactions();
        while (iterator.hasNext()) {
            long transactionStartTimeLong;
            ServerTransaction value = iterator.next();
            if (!(value instanceof LocalTransaction) || (transactionStartTimeLong = value.getTransactionStartTime()) <= 0L || oldest <= transactionStartTimeLong) continue;
            oldest = transactionStartTimeLong;
        }
        return oldest == Long.MAX_VALUE ? null : new Date(oldest);
    }

    @Override
    public long getLocalTransactionBegins() {
        return this._localTransactionBegins.get();
    }

    @Override
    public long getLocalTransactionOpen() {
        return this._localTransactionOpens.get();
    }

    @Override
    public long getLocalTransactionRollbacks() {
        return this._localTransactionRollbacks.get();
    }

    @Override
    public void incrementTransactionRollbackCounter() {
        this._localTransactionRollbacks.incrementAndGet();
    }

    @Override
    public void decrementTransactionOpenCounter() {
        this._localTransactionOpens.decrementAndGet();
    }

    @Override
    public void incrementTransactionOpenCounter() {
        this._localTransactionOpens.incrementAndGet();
    }

    @Override
    public void incrementTransactionBeginCounter() {
        this._localTransactionBegins.incrementAndGet();
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        this.logConnectionOpen();
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        this.getEventLogger().message(this._logSubject, ConnectionMessages.MODEL_DELETE());
    }

    private class SlowConnectionOpenTicker
    implements Ticker,
    SchedulingDelayNotificationListener {
        private final long _allowedTime;
        private volatile long _accumulatedSchedulingDelay;

        SlowConnectionOpenTicker(long timeoutTime) {
            this._allowedTime = timeoutTime;
        }

        @Override
        public int getTimeToNextTick(long currentTime) {
            return (int)(AbstractAMQPConnection.this.getCreatedTime().getTime() + this._allowedTime + this._accumulatedSchedulingDelay - currentTime);
        }

        @Override
        public int tick(long currentTime) {
            int nextTick = this.getTimeToNextTick(currentTime);
            if (nextTick <= 0) {
                if (AbstractAMQPConnection.this.isOpeningInProgress()) {
                    LOGGER.warn("Connection has taken more than {} ms to establish.  Closing as possible DoS.", (Object)this._allowedTime);
                    AbstractAMQPConnection.this.getEventLogger().message(ConnectionMessages.IDLE_CLOSE("Protocol connection is not established within timeout period", true));
                    AbstractAMQPConnection.this._network.close();
                } else {
                    AbstractAMQPConnection.this._aggregateTicker.removeTicker(this);
                    AbstractAMQPConnection.this._network.removeSchedulingDelayNotificationListeners(this);
                }
            }
            return nextTick;
        }

        @Override
        public void notifySchedulingDelay(long schedulingDelay) {
            if (schedulingDelay > 0L) {
                this._accumulatedSchedulingDelay += schedulingDelay;
            }
        }
    }
}

