/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.tree.LN;

public final class LNInfo {
    private final LN ln;
    private final DatabaseId dbId;
    private final byte[] key;
    private final long expirationTime;

    public LNInfo(LN ln, DatabaseId dbId, byte[] key, long expirationTime) {
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
        this.expirationTime = expirationTime;
    }

    LN getLN() {
        return this.ln;
    }

    DatabaseId getDbId() {
        return this.dbId;
    }

    byte[] getKey() {
        return this.key;
    }

    long getExpirationTime() {
        return this.expirationTime;
    }

    int getMemorySize() {
        int size = MemoryBudget.LN_INFO_OVERHEAD;
        if (this.ln != null) {
            size = (int)((long)size + this.ln.getMemorySizeIncludedByParent());
        }
        if (this.key != null) {
            size += MemoryBudget.byteArraySize(this.key.length);
        }
        return size;
    }
}

