/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractProcessService;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Scanner;

public abstract class AbstractStringProcessService<I, O>
extends AbstractProcessService<I, String, String, O> {
    protected AbstractStringProcessService(TypeTranslator<I, String> inTrans, TypeTranslator<String, O> outTrans, ReceptionCallback<O> callback, YamlService yaml) {
        super(inTrans, outTrans, callback, yaml);
    }

    @Override
    public void process(I data) throws IOException {
        PrintWriter w = this.getServiceIn();
        w.println((String)this.getInputTranslator().to(data));
        w.flush();
    }

    public void redirectIO(final InputStream in) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(in);
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    try {
                        AbstractStringProcessService.this.notifyCallbacks(AbstractStringProcessService.this.getOutputTranslator().to((Object)line));
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this.getClass()).error("Receiving result: " + e.getMessage());
                    }
                }
                sc.close();
            }
        }).start();
    }

    @Override
    protected void handleInputStream(InputStream in) {
        this.redirectIO(in);
    }
}

